/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.definitions.AppliedVectorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinitionBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.definitions.InterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.ScopedDefinitionBase;
import org.apache.royale.compiler.internal.definitions.TypeDefinitionBase;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.scopes.ASScopeBase;
import org.apache.royale.compiler.internal.scopes.NamespaceSetPredicate;
import org.apache.royale.compiler.internal.scopes.ScopeView;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeScope
extends ASScope {
    private static final StaticPredicate STATIC_ONLY_PREDICATE = new StaticPredicate(true);
    private static final StaticPredicate INSTANCE_ONLY_PREDICATE = new StaticPredicate(false);
    private final TypeDefinitionBase owningType;
    private StaticScope staticScope;
    private InstanceScope instanceScope;
    private boolean needsProtected;

    public TypeScope(ASScope containingScope, ScopedBlockNode block, TypeDefinitionBase owningType) {
        super(containingScope, block);
        this.owningType = owningType;
        this.initScopes(containingScope);
    }

    public TypeScope(ASScope containingScope, TypeDefinitionBase owningType) {
        super(containingScope);
        this.owningType = owningType;
        this.initScopes(containingScope);
    }

    private void initScopes(ASScope containingScope) {
        this.staticScope = this.createStaticScope(containingScope);
        this.instanceScope = this.createInstanceScope();
    }

    private StaticScope createStaticScope(ASScope containingScope) {
        return new StaticScope(containingScope, this);
    }

    private InstanceScope createInstanceScope() {
        return new InstanceScope((ASScope)this.staticScope, this);
    }

    public ASScope resolveSuperScope(ICompilerProject project, ScopeKind kind) {
        ASScope result = null;
        if (this.owningType instanceof IClassDefinition) {
            if (kind == ScopeKind.STATIC) {
                IASScope s;
                ITypeDefinition typeDef = project.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS);
                if (typeDef != null && (s = typeDef.getContainedScope()) instanceof TypeScope) {
                    result = ((TypeScope)s).getInstanceScope();
                }
            } else {
                IASScope superScope;
                IClassDefinition superClass = ((IClassDefinition)((Object)this.owningType)).resolveBaseClass(project);
                if (superClass instanceof TypeDefinitionBase && (superScope = superClass.getContainedScope()) instanceof TypeScope) {
                    switch (kind) {
                        case INSTANCE_AND_STATIC: {
                            result = (ASScope)superScope;
                            break;
                        }
                        case INSTANCE: {
                            result = ((TypeScope)superScope).getInstanceScope();
                            break;
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public void addDefinition(IDefinition definition) {
        if (definition != null) {
            this.addDefinitionToStore(definition);
            if (definition instanceof DefinitionBase) {
                ASScope containingScope;
                boolean isStatic = definition.isStatic();
                if (isStatic) {
                    containingScope = this.getStaticScope();
                } else {
                    containingScope = this.getInstanceScope();
                    if (!this.needsProtected) {
                        INamespaceDefinition protectedNameSpace = this.owningType.getProtectedNamespaceReference();
                        this.needsProtected = protectedNameSpace != null && protectedNameSpace.equals(definition.getNamespaceReference());
                    }
                }
                ((DefinitionBase)definition).setContainingScope(containingScope);
            }
        }
    }

    @Override
    protected void getPropertyForScopeChain(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.getPropertyForScopeChain(project, defs, baseName, namespaceSet, findAll, ScopeKind.INSTANCE_AND_STATIC);
    }

    void getPropertyForScopeChain(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate nsPred, boolean findAll, ScopeKind lookupKind) {
        ArrayList<ITypeDefinition> types = new ArrayList<ITypeDefinition>();
        for (ITypeDefinition type : this.owningType.typeIteratable(project, false)) {
            types.add(type);
        }
        int originalDefCount = defs.size();
        if (lookupKind.findInstance()) {
            boolean needProtectedNS = nsPred.containsNamespace(this.owningType.getProtectedNamespaceReference());
            ASScopeBase.FilteredCollection<IDefinition> iDefs = new ASScopeBase.FilteredCollection<IDefinition>(INSTANCE_ONLY_PREDICATE, defs);
            for (ITypeDefinition type : types) {
                ASScope typeScope = (ASScope)type.getContainedScope();
                if (needProtectedNS) {
                    nsPred.setExtraNamespace(type.getProtectedNamespaceReference());
                }
                typeScope.getLocalProperty((ICompilerProject)project, (Collection<IDefinition>)((Object)iDefs), baseName, true);
                if (findAll || defs.size() <= originalDefCount) continue;
                return;
            }
        }
        if (lookupKind.findStatics()) {
            ASScopeBase.FilteredCollection<IDefinition> sDefs = new ASScopeBase.FilteredCollection<IDefinition>(STATIC_ONLY_PREDICATE, defs);
            for (ITypeDefinition type : types) {
                ASScope typeScope = (ASScope)type.getContainedScope();
                typeScope.getLocalProperty((ICompilerProject)project, (Collection<IDefinition>)((Object)sDefs), baseName, true);
                if (findAll || defs.size() <= originalDefCount) continue;
                return;
            }
        }
    }

    @Override
    protected void getPropertyForMemberAccess(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.getPropertyForMemberAccess(project, defs, baseName, namespaceSet, findAll, ScopeKind.INSTANCE_AND_STATIC);
    }

    protected void getPropertyForMemberAccess(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll, ScopeKind lookupKind) {
        int originalDefCount = defs.size();
        boolean needProtectedNamespaces = namespaceSet == ASScopeBase.allNamespacesSet || namespaceSet.containsNamespace(this.owningType.getProtectedNamespaceReference());
        NamespaceSetPredicate nsPred = namespaceSet;
        ASScopeBase.FilteredCollection<IDefinition> iDefs = new ASScopeBase.FilteredCollection<IDefinition>(INSTANCE_ONLY_PREDICATE, defs);
        if (lookupKind.findInstance()) {
            for (ITypeDefinition type : this.owningType.typeIteratable(project, false)) {
                ASScope typeScope = (ASScope)type.getContainedScope();
                if (needProtectedNamespaces) {
                    nsPred.setExtraNamespace(type.getProtectedNamespaceReference());
                }
                typeScope.getLocalProperty((ICompilerProject)project, (Collection<IDefinition>)((Object)iDefs), baseName, true);
                if (defs.size() <= originalDefCount || findAll) continue;
                return;
            }
        }
        if (lookupKind.findStatics()) {
            ASScopeBase.FilteredCollection<IDefinition> sDefs = new ASScopeBase.FilteredCollection<IDefinition>(STATIC_ONLY_PREDICATE, defs);
            for (ITypeDefinition type : this.owningType.staticTypeIterable(project, false)) {
                ASScope typeScope;
                if (type == null) continue;
                typeScope.getLocalProperty((ICompilerProject)project, (Collection<IDefinition>)((Object)((typeScope = (ASScope)type.getContainedScope()) == this ? sDefs : iDefs)), baseName, true);
                if (defs.size() <= originalDefCount || findAll) continue;
                return;
            }
        }
    }

    private MemberAccessCollections getFilteredCollectionsForMemberAccess(Collection<IDefinition> defs, ScopeKind lookupKind) {
        MemberAccessCollections p = null;
        if (lookupKind.findInstance() && lookupKind.findStatics()) {
            p = new MemberAccessCollections(defs, defs);
        } else if (lookupKind.findStatics()) {
            p = new MemberAccessCollections((Collection<IDefinition>)((Object)new ASScopeBase.FilteredCollection<IDefinition>(STATIC_ONLY_PREDICATE, defs)), (Collection<IDefinition>)((Object)new ASScopeBase.FilteredCollection<IDefinition>(INSTANCE_ONLY_PREDICATE, defs)));
        } else if (lookupKind.findInstance()) {
            ASScopeBase.FilteredCollection<IDefinition> c = new ASScopeBase.FilteredCollection<IDefinition>(INSTANCE_ONLY_PREDICATE, defs);
            p = new MemberAccessCollections((Collection<IDefinition>)((Object)c), (Collection<IDefinition>)((Object)c));
        }
        return p;
    }

    @Override
    public void getAllPropertiesForScopeChain(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.getAllPropertiesForScopeChain(project, defs, namespaceSet, ScopeKind.INSTANCE_AND_STATIC);
    }

    @Override
    public void getAllPropertiesForMemberAccess(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.getAllPropertiesForMemberAccess(project, defs, namespaceSet, ScopeKind.INSTANCE_AND_STATIC);
    }

    protected void getAllPropertiesForMemberAccess(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet, ScopeKind lookupKind) {
        ArrayList<ITypeDefinition> types = new ArrayList<ITypeDefinition>();
        for (ITypeDefinition type : lookupKind == ScopeKind.STATIC ? this.owningType.staticTypeIterable(project, false) : this.owningType.typeIteratable(project, false)) {
            types.add(type);
        }
        MemberAccessCollections p = this.getFilteredCollectionsForMemberAccess(defs, lookupKind);
        Collection<IDefinition> thisScopeDefs = p.thisScopeCollection;
        Collection<IDefinition> baseScopeDefs = p.baseScopeCollection;
        boolean needsProtected = false;
        if (namespaceSet != null) {
            needsProtected = namespaceSet.contains(this.owningType.getProtectedNamespaceReference());
        }
        for (ITypeDefinition type : types) {
            ASScope typeScope = (ASScope)type.getContainedScope();
            INamespaceDefinition protectedNamespace = null;
            if (needsProtected) {
                protectedNamespace = type.getProtectedNamespaceReference();
            }
            typeScope.getAllLocalProperties(project, typeScope == this ? thisScopeDefs : baseScopeDefs, namespaceSet, protectedNamespace);
        }
    }

    protected void getAllPropertiesForScopeChain(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet, ScopeKind lookupKind) {
        ArrayList<ITypeDefinition> types = new ArrayList<ITypeDefinition>();
        for (ITypeDefinition type : this.owningType.typeIteratable(project, false)) {
            types.add(type);
        }
        boolean needsProtected = false;
        if (namespaceSet != null) {
            needsProtected = namespaceSet.contains(this.owningType.getProtectedNamespaceReference());
        }
        defs = this.getFilteredCollectionForScopeChainLookup(defs, lookupKind);
        for (ITypeDefinition type : types) {
            ASScope typeScope = (ASScope)type.getContainedScope();
            INamespaceDefinition protectedNamespace = null;
            if (needsProtected) {
                protectedNamespace = type.getProtectedNamespaceReference();
            }
            typeScope.getAllLocalProperties(project, defs, namespaceSet, protectedNamespace);
        }
    }

    private Collection<IDefinition> getFilteredCollectionForScopeChainLookup(Collection<IDefinition> defs, ScopeKind lookupKind) {
        if (!lookupKind.findInstance() || !lookupKind.findStatics()) {
            if (lookupKind.findStatics()) {
                defs = new ASScopeBase.FilteredCollection<IDefinition>(STATIC_ONLY_PREDICATE, (Collection<IDefinition>)defs);
            } else if (lookupKind.findInstance()) {
                defs = new ASScopeBase.FilteredCollection<IDefinition>(INSTANCE_ONLY_PREDICATE, (Collection<IDefinition>)defs);
            }
        }
        return defs;
    }

    @Override
    protected boolean namespaceSetSameAsContainingScopeNamespaceSet() {
        return false;
    }

    @Override
    public void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        this.addImplicitOpenNamespaces(compilerProject, result, ScopeKind.INSTANCE_AND_STATIC);
    }

    protected void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result, ScopeKind lookupKind) {
        block7: {
            ScopedDefinitionBase currentDefinition;
            block6: {
                currentDefinition = this.getDefinition();
                if (!(currentDefinition instanceof ClassDefinition)) break block6;
                ClassDefinition initialClassDef = (ClassDefinition)currentDefinition;
                result.add(initialClassDef.getPrivateNamespaceReference());
                if (lookupKind.findInstance()) {
                    result.add(initialClassDef.getProtectedNamespaceReference());
                }
                if (!lookupKind.findStatics()) break block7;
                for (IClassDefinition classDef : initialClassDef.classIterable(compilerProject, true)) {
                    result.add(((ClassDefinition)classDef).getStaticProtectedNamespaceReference());
                }
                break block7;
            }
            if (currentDefinition instanceof InterfaceDefinition) {
                InterfaceDefinition interfaceDefinition = (InterfaceDefinition)currentDefinition;
                result.add(interfaceDefinition.getInterfaceNamespaceReference());
            } else if (currentDefinition instanceof AppliedVectorDefinition) {
                compilerProject.addGlobalUsedNamespacesToNamespaceSet(result);
                for (IClassDefinition classDef : ((AppliedVectorDefinition)currentDefinition).classIterable(compilerProject, true)) {
                    result.add(((ClassDefinitionBase)classDef).getStaticProtectedNamespaceReference());
                }
            }
        }
    }

    @Override
    public String getContainingSourcePath(String baseName, ICompilerProject project) {
        return super.getContainingSourcePath(this.owningType.getQualifiedName(), project);
    }

    public ASScope getInstanceScope() {
        return this.instanceScope;
    }

    public ASScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public void setContainingScope(ASScope containingScope) {
        super.setContainingScope(containingScope);
        if (this.staticScope != null) {
            this.staticScope.setContainingScope(containingScope);
        }
    }

    public boolean getNeedsProtected() {
        return this.needsProtected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StaticPredicate
    implements Predicate<IDefinition> {
        private boolean findStatics;

        public StaticPredicate(boolean b) {
            this.findStatics = b;
        }

        public boolean apply(IDefinition definition) {
            return this.findStatics == definition.isStatic();
        }

        public boolean test(IDefinition input) {
            return this.apply(input);
        }
    }

    private static class StaticScope
    extends ScopeView {
        StaticScope(ASScope containingScope, TypeScope typeScope) {
            super(containingScope, typeScope);
        }

        protected ScopeKind getScopeKind() {
            return ScopeKind.STATIC;
        }
    }

    private static class InstanceScope
    extends ScopeView {
        InstanceScope(ASScope containingScope, TypeScope typeScope) {
            super(containingScope, typeScope);
        }

        protected ScopeKind getScopeKind() {
            return ScopeKind.INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberAccessCollections {
        public final Collection<IDefinition> thisScopeCollection;
        public final Collection<IDefinition> baseScopeCollection;

        public MemberAccessCollections(Collection<IDefinition> thisDefs, Collection<IDefinition> baseDefs) {
            this.thisScopeCollection = thisDefs;
            this.baseScopeCollection = baseDefs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ScopeKind
    extends Enum<ScopeKind> {
        public static final /* enum */ ScopeKind INSTANCE_AND_STATIC = new ScopeKind();
        public static final /* enum */ ScopeKind INSTANCE = new ScopeKind();
        public static final /* enum */ ScopeKind STATIC = new ScopeKind();
        private static final /* synthetic */ ScopeKind[] $VALUES;

        public static ScopeKind[] values() {
            return (ScopeKind[])$VALUES.clone();
        }

        public static ScopeKind valueOf(String name) {
            return Enum.valueOf(ScopeKind.class, name);
        }

        boolean findInstance() {
            return this == INSTANCE || this == INSTANCE_AND_STATIC;
        }

        boolean findStatics() {
            return this == STATIC || this == INSTANCE_AND_STATIC;
        }

        boolean findDefinition(IDefinition definition) {
            if (this == INSTANCE) {
                return !definition.isStatic();
            }
            if (this == STATIC) {
                return definition.isStatic();
            }
            if (this == INSTANCE_AND_STATIC) {
                return true;
            }
            assert (false) : "Unknown ScopeKind";
            return false;
        }

        static {
            $VALUES = new ScopeKind[]{INSTANCE_AND_STATIC, INSTANCE, STATIC};
        }
    }
}

