/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.scopes;

import com.google.common.base.Predicate;
import java.util.Set;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.internal.scopes.ASScopeBase;
import org.apache.royale.compiler.projects.ICompilerProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceSetPredicate
implements Predicate<IDefinition> {
    private final ICompilerProject project;
    private final Set<INamespaceDefinition> namespaceSet;
    private INamespaceDefinition extraNamespace;

    public NamespaceSetPredicate(ICompilerProject project, Set<INamespaceDefinition> namespaceSet) {
        this.project = project;
        this.namespaceSet = namespaceSet;
    }

    public boolean apply(IDefinition definition) {
        INamespaceReference nsRef = definition.getNamespaceReference();
        if (this.namespaceSet == ASScopeBase.allNamespacesSet) {
            return true;
        }
        if (this.extraNamespace != null && nsRef == this.extraNamespace) {
            return true;
        }
        INamespaceDefinition namespace = definition.resolveNamespace(this.project);
        if (this.namespaceSet.contains(namespace)) {
            return true;
        }
        return this.extraNamespace != null && (namespace == this.extraNamespace || this.extraNamespace.equals(namespace));
    }

    public boolean test(IDefinition input) {
        return this.apply(input);
    }

    public boolean containsNamespace(INamespaceDefinition d) {
        return this.namespaceSet != null && this.namespaceSet.contains(d);
    }

    public void setExtraNamespace(INamespaceDefinition extra) {
        this.extraNamespace = extra;
    }

    public Set<INamespaceDefinition> getNamespaceSet() {
        return this.namespaceSet;
    }
}

