/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.BaseRepairingTokenBuffer;
import org.apache.royale.compiler.internal.parsing.as.IRepairingTokenBuffer;
import org.apache.royale.compiler.parsing.IASToken;

public class RepairingTokenBuffer
extends BaseRepairingTokenBuffer
implements IRepairingTokenBuffer {
    private final ASToken[] tokens;
    private final int size;
    private final LinkedHashSet<Integer> semicolonInsertions;

    public RepairingTokenBuffer(ASToken[] tokens) {
        super(null);
        this.tokens = tokens;
        this.size = tokens.length;
        this.semicolonInsertions = new LinkedHashSet();
    }

    public final boolean insertSemicolon(boolean isNextToken) {
        if (!this.insertSemis) {
            return false;
        }
        boolean isAdded = this.semicolonInsertions.add(this.position - 1);
        if (isAdded && isNextToken) {
            this.onSemicolonInserted();
        }
        return isAdded;
    }

    public final void rewind(int position) {
        this.position = position;
    }

    public final void consume() {
        if (this.nextIsSemicolon) {
            this.nextIsSemicolon = false;
        } else {
            ++this.position;
        }
    }

    protected final ASToken lookAheadSkipInsertedSemicolon(int i) {
        int lookAheadPos = this.position + i - 1;
        if (lookAheadPos < this.size) {
            return this.tokens[lookAheadPos];
        }
        return this.eofToken;
    }

    public IASToken[] getTokens(boolean includeInserted) {
        if (!includeInserted) {
            return this.tokens;
        }
        ArrayList<ASToken> tokens = new ArrayList<ASToken>(Arrays.asList(this.tokens));
        int adjust = 0;
        for (Integer pos : this.semicolonInsertions) {
            ASToken tokenBeforeSemicolon = (ASToken)tokens.get(pos);
            ASToken semicolon = new ASToken(55, tokenBeforeSemicolon.getEnd(), tokenBeforeSemicolon.getEnd(), tokenBeforeSemicolon.getLine(), tokenBeforeSemicolon.getColumn() + 1, ";");
            int insertIndex = pos + ++adjust;
            tokens.add(insertIndex, semicolon);
        }
        return tokens.toArray(new ASToken[0]);
    }

    public ASToken previous() {
        int prevPos = this.position - 2;
        if (prevPos < this.size && prevPos > 0) {
            return this.tokens[prevPos];
        }
        return this.eofToken;
    }

    public boolean matchOptionalSemicolon() {
        if (this.LA(1) == 55) {
            this.consume();
        } else {
            this.insertSemicolon(false);
        }
        return true;
    }
}

