/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.asdoc.IMetadataParserASDocDelegate;
import org.apache.royale.compiler.internal.parsing.as.MetadataParser;
import org.apache.royale.compiler.internal.parsing.as.MetadataToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataTokenizer;
import org.apache.royale.compiler.internal.parsing.as.NilASDocDelegate;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.metadata.BaseDefinitionMetaTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagsNode;
import org.apache.royale.compiler.parsing.GenericTokenStream;
import org.apache.royale.compiler.parsing.IMetadataParser;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

public class BaseMetaTagParser
extends LLkParser
implements IMetadataParser {
    protected IMetadataParserASDocDelegate asDocDelegate = NilASDocDelegate.get().getASParserASDocDelegate().getMetadataParserASDocDelegate();

    public BaseMetaTagParser(int arg0) {
        super(arg0);
    }

    public BaseMetaTagParser(ParserSharedInputState arg0, int arg1) {
        super(arg0, arg1);
    }

    public BaseMetaTagParser(TokenBuffer arg0, int arg1) {
        super(arg0, arg1);
    }

    public BaseMetaTagParser(TokenStream arg0, int arg1) {
        super(arg0, arg1);
    }

    protected void handleComment(Token docToken) {
        this.asDocDelegate.setCurrentASDocToken(docToken);
    }

    protected void resetComments(String name) {
        this.asDocDelegate.clearMetadataComment(name);
    }

    protected void afterTag(MetaTagNode tag, Token openBrace, Token closeBrace, Token closeParen) throws TokenStreamException {
        if (tag != null && openBrace != null) {
            if (closeBrace != null) {
                tag.span(openBrace, closeBrace);
            } else if (closeParen != null) {
                tag.span(openBrace, closeParen);
            } else {
                tag.span(openBrace, this.LT(0));
            }
        }
        if (tag != null) {
            this.asDocDelegate.afterMetadata(tag.getAbsoluteEnd());
        }
    }

    public void reportError(RecognitionException ex) {
    }

    protected final String getText(Token token) {
        return token != null ? token.getText() : "";
    }

    protected final IdentifierNode build(Token token) {
        IdentifierNode name = new IdentifierNode(this.getText(token));
        name.span(token);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IMetaTagsNode parse(Reader reader) {
        MetaTagsNode metaTagsNode;
        MetadataTokenizer tokenizer = new MetadataTokenizer(reader);
        try {
            try {
                List<MetadataToken> tokens = tokenizer.parseTokens();
                MetaTagsNode node = new MetaTagsNode();
                new MetadataParser(new GenericTokenStream(tokens)).meta(node);
                metaTagsNode = node;
                Object var7_8 = null;
            }
            catch (ANTLRException e) {
                IMetaTagsNode iMetaTagsNode = null;
                Object var7_9 = null;
                try {
                    reader.close();
                    return iMetaTagsNode;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return iMetaTagsNode;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            reader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return metaTagsNode;
        }
        reader.close();
        return metaTagsNode;
    }

    void applyComment(BaseDefinitionMetaTagNode node) {
        IASDocComment asDoc = this.asDocDelegate.afterDefinition(node);
        if (asDoc != null) {
            node.setASDocComment(asDoc);
        }
    }

    public void setASDocDelegate(IMetadataParserASDocDelegate asDocDelegate) {
        this.asDocDelegate = asDocDelegate;
    }
}

