/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.graph;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.compiler.internal.graph.Graph;
import org.apache.royale.compiler.internal.graph.IGraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedGraph<V, E extends IGraphEdge<V>>
extends Graph<V, E> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVertex(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.addVertex waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            boolean bl = super.addVertex(vertex);
            Object var4_3 = null;
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.addVertex dpne with lock for " + this.getClass().getSimpleName());
            }
            return bl;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                this.lock.writeLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                System.out.println("SynchronizedGraph.addVertex dpne with lock for " + this.getClass().getSimpleName());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVertex(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.removeVertex waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.writeLock().lock();
        try {
            super.removeVertex(vertex);
            Object var3_2 = null;
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.removeVertex dpne with lock for " + this.getClass().getSimpleName());
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.writeLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.removeVertex dpne with lock for " + this.getClass().getSimpleName());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E setEdge(V from, V to, E e) {
        E e2;
        block3: {
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.setEdge waiting for lock for " + this.getClass().getSimpleName());
            }
            this.lock.writeLock().lock();
            try {
                e2 = super.setEdge(e);
                Object var6_5 = null;
                this.lock.writeLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block3;
                System.out.println("SynchronizedGraph.setEdge dpne with lock for " + this.getClass().getSimpleName());
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    this.lock.writeLock().unlock();
                    if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                    System.out.println("SynchronizedGraph.setEdge dpne with lock for " + this.getClass().getSimpleName());
                }
                throw throwable;
            }
        }
        return e2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getEdge(V from, V to) {
        Object e;
        block3: {
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getEdge waiting for lock for " + this.getClass().getSimpleName());
            }
            this.lock.writeLock().lock();
            try {
                e = super.getEdge(from, to);
                Object var5_4 = null;
                this.lock.writeLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block3;
                System.out.println("SynchronizedGraph.getEdge dpne with lock for " + this.getClass().getSimpleName());
            }
            catch (Throwable throwable) {
                block4: {
                    Object var5_5 = null;
                    this.lock.writeLock().unlock();
                    if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                    System.out.println("SynchronizedGraph.getEdge dpne with lock for " + this.getClass().getSimpleName());
                }
                throw throwable;
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getOutgoingEdges(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getOutgoingEdges waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getOutgoingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            Object var5_4 = null;
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getOutgoingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
            return set;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                this.lock.readLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                System.out.println("SynchronizedGraph.getOutgoingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getIncomingEdges(V vertex) {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getIncomingEdges waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getIncomingEdges(vertex);
            Set set = result == Collections.EMPTY_SET ? result : Collections.unmodifiableSet(new HashSet(result));
            Object var5_4 = null;
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getIncomingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
            return set;
        }
        catch (Throwable throwable) {
            block4: {
                Object var5_5 = null;
                this.lock.readLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                System.out.println("SynchronizedGraph.getIncomingEdges dpne with lock for " + this.getClass().getSimpleName());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E removeEdge(E edge) {
        E e;
        block3: {
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.removeEdge waiting for lock for " + this.getClass().getSimpleName());
            }
            this.lock.writeLock().lock();
            try {
                e = super.removeEdge(edge);
                Object var4_3 = null;
                this.lock.writeLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block3;
                System.out.println("SynchronizedGraph.removeEdge dpne with lock for " + this.getClass().getSimpleName());
            }
            catch (Throwable throwable) {
                block4: {
                    Object var4_4 = null;
                    this.lock.writeLock().unlock();
                    if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                    System.out.println("SynchronizedGraph.removeEdge dpne with lock for " + this.getClass().getSimpleName());
                }
                throw throwable;
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> getVertices() {
        if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
            System.out.println("SynchronizedGraph.getVertices waiting for lock for " + this.getClass().getSimpleName());
        }
        this.lock.readLock().lock();
        try {
            Set result = super.getVertices();
            Set set = Collections.unmodifiableSet(new HashSet(result));
            Object var4_3 = null;
            this.lock.readLock().unlock();
            if ((CompilerDiagnosticsConstants.diagnostics & 8) == 8) {
                System.out.println("SynchronizedGraph.getVertices dpne with lock for " + this.getClass().getSimpleName());
            }
            return set;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                this.lock.readLock().unlock();
                if ((CompilerDiagnosticsConstants.diagnostics & 8) != 8) break block4;
                System.out.println("SynchronizedGraph.getVertices dpne with lock for " + this.getClass().getSimpleName());
            }
            throw throwable;
        }
    }

    public Lock writeLock() {
        return this.lock.writeLock();
    }

    public Lock readLock() {
        return this.lock.readLock();
    }
}

