/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom;

import java.util.Collection;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.types.FillMode;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitmapGraphicNode
extends GraphicContentNode {
    public double width = Double.NaN;
    public double height = Double.NaN;
    public String source;
    public boolean repeat = true;
    public FillMode fillMode = FillMode.SCALE;

    @Override
    public String getNodeName() {
        if (this.getFileVersion().equals(FXGVersion.v1_0)) {
            return "BitmapGraphic";
        }
        return "BitmapImage";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else if ("source".equals(name)) {
            this.source = value;
        } else if (this.getFileVersion().equalTo(FXGVersion.v1_0) && "repeat".equals(name)) {
            this.repeat = DOMParserHelper.parseBoolean(this, value, name, this.repeat, problems);
        } else if (!this.getFileVersion().equalTo(FXGVersion.v1_0) && "fillMode".equals(name)) {
            this.fillMode = DOMParserHelper.parseFillMode(this, value, this.fillMode, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

