/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.filespecs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.royale.compiler.filespecs.CombinedFile;
import org.apache.royale.compiler.filespecs.IBinaryFileSpecification;
import org.apache.royale.swc.ISWCFileEntry;

public class SWCFileSpecification
implements IBinaryFileSpecification {
    private final String path;
    private final ISWCFileEntry fileEntry;

    public SWCFileSpecification(String path, ISWCFileEntry fileEntry) {
        assert (fileEntry == null || fileEntry.getPath().equals(path)) : "fileEntry path must equal specified path";
        this.path = path;
        this.fileEntry = fileEntry;
    }

    public String getPath() {
        return this.path;
    }

    public Reader createReader() throws FileNotFoundException {
        if (this.fileEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        try {
            return this.createNIOReader();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            return new Reader(){

                public int read(char[] cbuf, int off, int len) throws IOException {
                    throw e;
                }

                public void close() throws IOException {
                }
            };
        }
    }

    public long getLastModified() {
        if (this.fileEntry == null) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        return this.fileEntry.getLastModified();
    }

    public boolean isOpenDocument() {
        return false;
    }

    public InputStream createInputStream() throws IOException {
        if (this.fileEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        return this.fileEntry.createInputStream();
    }

    private Reader createNIOReader() throws IOException {
        InputStream strm = this.createInputStream();
        BufferedInputStream bufferedStrm = strm instanceof BufferedInputStream ? (BufferedInputStream)strm : new BufferedInputStream(strm);
        CombinedFile.BOM bom = CombinedFile.getBOM(bufferedStrm);
        bufferedStrm.skip(bom.pattern.length);
        return new BufferedReader(new InputStreamReader((InputStream)bufferedStrm, bom.charset));
    }

    public void setLastModified(long fileDate) {
    }
}

