/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.embedding.transcoders;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.royale.compiler.common.IFileSpecificationGetter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.caches.SWFCache;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.transcoders.ScalableTranscoder;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.targets.RoyaleFontInfo;
import org.apache.royale.compiler.internal.targets.TagSorter;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ConditionalNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.FileNode;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.GetterNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.IfNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.LanguageIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.ModifierNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.ReturnNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.EmbedAS2TagsModifiedProblem;
import org.apache.royale.compiler.problems.EmbedBadScalingGridTargetProblem;
import org.apache.royale.compiler.problems.EmbedMissingSymbolProblem;
import org.apache.royale.compiler.problems.EmbedMovieScalingNoSymbolProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.ISWCManager;
import org.apache.royale.swf.ISWF;
import org.apache.royale.swf.io.SWFReader;
import org.apache.royale.swf.tags.DefineBitsLosslessTag;
import org.apache.royale.swf.tags.DefineBitsTag;
import org.apache.royale.swf.tags.DefineButtonTag;
import org.apache.royale.swf.tags.DefineFont2Tag;
import org.apache.royale.swf.tags.DefineFont4Tag;
import org.apache.royale.swf.tags.DefineFontTag;
import org.apache.royale.swf.tags.DefineScalingGridTag;
import org.apache.royale.swf.tags.DefineSoundTag;
import org.apache.royale.swf.tags.DefineSpriteTag;
import org.apache.royale.swf.tags.DefineTextTag;
import org.apache.royale.swf.tags.ExportAssetsTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.swf.tags.PlaceObject2Tag;
import org.apache.royale.swf.tags.SymbolClassTag;
import org.apache.royale.swf.types.Rect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieTranscoder
extends ScalableTranscoder {
    private String symbol = null;
    private ICharacterTag symbolTag = null;
    private RoyaleFontInfo royaleFontInfo = null;
    private int swfWidth = 0;
    private int swfHeight = 0;

    public MovieTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        Rect swfSize;
        boolean result = super.analyze(location, problems);
        if (!result) {
            return false;
        }
        SWFReader swfReader = this.getSWFReader(problems);
        if (swfReader == null) {
            return false;
        }
        ISWF swf = swfReader.getSWF();
        if (swf == null) {
            return false;
        }
        if (this.symbol == null) {
            this.baseClassQName = "mx.core.MovieClipLoaderAsset";
            if (this.scaling) {
                problems.add(new EmbedMovieScalingNoSymbolProblem(location));
            }
        } else {
            this.symbolTag = this.getSWFTag(swfReader, this.symbol, problems);
            if (this.symbolTag == null) {
                problems.add(new EmbedMissingSymbolProblem(location, this.source, this.symbol));
                return false;
            }
            if (this.scaling && !(this.symbolTag instanceof DefineSpriteTag)) {
                problems.add(new EmbedBadScalingGridTargetProblem(location, this.symbol));
                return false;
            }
            this.baseClassQName = swf.getFrameCount() > 1 ? "mx.core.MovieClipLoaderAsset" : this.getAssociatedClass(this.symbolTag);
            if (this.symbolTag instanceof DefineFont2Tag) {
                this.royaleFontInfo = new RoyaleFontInfo(((DefineFont2Tag)this.symbolTag).isFontFlagsBold(), ((DefineFont2Tag)this.symbolTag).isFontFlagsItalic());
            } else if (this.symbolTag instanceof DefineFont4Tag) {
                this.royaleFontInfo = new RoyaleFontInfo(((DefineFont4Tag)this.symbolTag).isFontFlagsBold(), ((DefineFont4Tag)this.symbolTag).isFontFlagsItalic());
            }
        }
        if ((swfSize = swf.getFrameSize()) != null) {
            this.swfWidth = swfSize.getWidth() / 20;
            this.swfHeight = swfSize.getHeight() / 20;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SYMBOL: {
                this.symbol = (String)this.data.getAttribute(EmbedAttribute.SYMBOL);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        String symbolName;
        ICharacterTag assetTag = null;
        if (this.symbolTag != null) {
            symbolName = this.data.getQName();
            LinkedHashSet<ITag> sortedTags = new LinkedHashSet<ITag>();
            sortedTags.addAll(TagSorter.sortFullGraph(Collections.singletonList(this.symbolTag)));
            if (this.scaling) {
                tags.addAll(sortedTags);
                assetTag = this.scaleExistingSprite((DefineSpriteTag)this.symbolTag, tags, problems);
            } else {
                sortedTags.remove(this.symbolTag);
                tags.addAll(sortedTags);
                assetTag = this.symbolTag;
            }
        } else {
            symbolName = this.data.getQName() + "ByteArray";
            assetTag = this.buildBinaryDataTag(problems);
            if (assetTag == null) {
                return null;
            }
        }
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(symbolName, assetTag);
        return symbolTags;
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        if (this.symbolTag != null) {
            return super.buildAST((Collection)problems, filename);
        }
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode packageContents = packageNode.getScopedNode();
        ImportNode importNode = ImportNode.buildImportNode(this.getBaseClassQName());
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("mx.core.ByteArrayAsset");
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("flash.utils.ByteArray");
        packageContents.addItem(importNode);
        String byteArrayClassName = this.data.getQName() + "ByteArray";
        ClassNode classNodeByteArray = new ClassNode(new IdentifierNode(byteArrayClassName));
        classNodeByteArray.setBaseClass(new IdentifierNode("ByteArrayAsset"));
        classNodeByteArray.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodeByteArray);
        String movieClassName = this.data.getQName();
        ClassNode classNodeMovie = new ClassNode(new IdentifierNode(movieClassName));
        classNodeMovie.setBaseClass(new IdentifierNode(this.getBaseClassName()));
        classNodeMovie.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodeMovie);
        ScopedBlockNode classNodeMovieContents = classNodeMovie.getScopedNode();
        VariableNode variableNodeBytes = new VariableNode(new IdentifierNode("bytes"));
        variableNodeBytes.setNamespace(new NamespaceIdentifierNode("private"));
        variableNodeBytes.addModifier(new ModifierNode("static"));
        variableNodeBytes.setType(null, new IdentifierNode("ByteArray"));
        ASToken assignToken = new ASToken(53, -1, -1, -1, -1, "=");
        ASToken nullToken = new ASToken(119, -1, -1, -1, -1, "null");
        LiteralNode nullNode = new LiteralNode(ILiteralNode.LiteralType.NULL, nullToken);
        variableNodeBytes.setAssignedValue(assignToken, nullNode);
        classNodeMovieContents.addItem(variableNodeBytes);
        IdentifierNode constructorNameNode = new IdentifierNode(movieClassName);
        constructorNameNode.setReferenceValue(classNodeMovie.getDefinition());
        FunctionNode constructorNode = new FunctionNode(null, constructorNameNode);
        constructorNode.setNamespace(new NamespaceIdentifierNode("public"));
        ScopedBlockNode constructorContents = constructorNode.getScopedNode();
        FunctionCallNode superCall = new FunctionCallNode(LanguageIdentifierNode.buildSuper());
        constructorContents.addItem(superCall);
        NumericLiteralNode widthNode = new NumericLiteralNode(Integer.toString(this.swfWidth));
        BinaryOperatorNodeBase assignmentWidth = BinaryOperatorNodeBase.create(assignToken, new IdentifierNode("initialWidth"), widthNode);
        constructorContents.addItem(assignmentWidth);
        NumericLiteralNode heightNode = new NumericLiteralNode(Integer.toString(this.swfHeight));
        BinaryOperatorNodeBase assignmentHeight = BinaryOperatorNodeBase.create(assignToken, new IdentifierNode("initialHeight"), heightNode);
        constructorContents.addItem(assignmentHeight);
        classNodeMovieContents.addItem(constructorNode);
        GetterNode movieClipDataGetterNode = new GetterNode(null, null, new IdentifierNode("movieClipData"));
        movieClipDataGetterNode.addModifier(new ModifierNode("override"));
        movieClipDataGetterNode.setNamespace(new NamespaceIdentifierNode("public"));
        movieClipDataGetterNode.setType(null, new IdentifierNode("ByteArray"));
        ScopedBlockNode movieClipDataContents = movieClipDataGetterNode.getScopedNode();
        ASToken compareToken = new ASToken(94, -1, -1, -1, -1, "==");
        BinaryOperatorNodeBase nullCheck = BinaryOperatorNodeBase.create(compareToken, new IdentifierNode("bytes"), new LiteralNode(ILiteralNode.LiteralType.NULL, nullToken));
        IfNode ifStmt = new IfNode(null);
        ConditionalNode cNode = new ConditionalNode(null);
        cNode.setConditionalExpression(nullCheck);
        ifStmt.addBranch(cNode);
        movieClipDataContents.addItem(ifStmt);
        BlockNode ifContents = cNode.getContentsNode();
        ASToken newToken = new ASToken(153, -1, -1, -1, -1, "new");
        FunctionCallNode newBytes = new FunctionCallNode(newToken, new IdentifierNode(byteArrayClassName));
        FunctionCallNode byteArrayCall = new FunctionCallNode(new IdentifierNode("ByteArray"));
        ContainerNode args = byteArrayCall.getArgumentsNode();
        args.addItem(newBytes);
        BinaryOperatorNodeBase assignmentBytes = BinaryOperatorNodeBase.create(assignToken, new IdentifierNode("bytes"), byteArrayCall);
        ifContents.addItem(assignmentBytes);
        ReturnNode returnStmt = new ReturnNode(null);
        returnStmt.setStatementExpression(new IdentifierNode("bytes"));
        movieClipDataContents.addItem(returnStmt);
        classNodeMovieContents.addItem(movieClipDataGetterNode);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public RoyaleFontInfo getRoyaleFontInfo() {
        return this.royaleFontInfo;
    }

    private SWFReader getSWFReader(Collection<ICompilerProblem> problems) {
        SWFCache.SWFCacheKey cacheKey;
        ISWCManager swcManager = this.workspace.getSWCManager();
        if (this.swcSource == null) {
            cacheKey = SWFCache.createKey(this.source);
        } else {
            ISWC swc = swcManager.get(new File(this.swcSource.getContainingSWCPath()));
            cacheKey = SWFCache.createKey(swc, this.source);
        }
        SWFCache swfCache = (SWFCache)this.workspace.getSWCManager().getSWFCache();
        SWFReader swfReader = (SWFReader)swfCache.get(cacheKey);
        return swfReader;
    }

    private ICharacterTag getSWFTag(SWFReader swfReader, String tagName, Collection<ICompilerProblem> problems) {
        boolean tagsModified;
        ICharacterTag characterTag = null;
        for (ITag tag : swfReader) {
            ExportAssetsTag exportAssetsTag;
            SymbolClassTag symbolClassTag;
            if (tag instanceof SymbolClassTag ? (characterTag = (symbolClassTag = (SymbolClassTag)tag).getSymbol(tagName)) != null : tag instanceof ExportAssetsTag && (characterTag = (exportAssetsTag = (ExportAssetsTag)tag).getCharacterTagByName(tagName)) != null) break;
        }
        if (characterTag != null && (tagsModified = this.modifyTagsForEmbedding(characterTag))) {
            problems.add(new EmbedAS2TagsModifiedProblem(this.symbol));
        }
        return characterTag;
    }

    private boolean modifyTagsForEmbedding(ICharacterTag tag) {
        DefineButtonTag buttonTag;
        byte[] actions;
        boolean tagsModified = false;
        if (tag instanceof DefineSpriteTag) {
            DefineSpriteTag spriteTag = (DefineSpriteTag)tag;
            for (ITag controlTag : spriteTag.getControlTags()) {
                if (!(controlTag instanceof PlaceObject2Tag)) continue;
                PlaceObject2Tag placeObject = (PlaceObject2Tag)controlTag;
                if (placeObject.isHasClipActions()) {
                    placeObject.setCharacter(null);
                    tagsModified = true;
                }
                if (!placeObject.isHasCharacter()) continue;
                tagsModified |= this.modifyTagsForEmbedding(placeObject.getCharacter());
            }
        } else if (tag instanceof DefineButtonTag && (actions = (buttonTag = (DefineButtonTag)tag).getActions()) != null && actions.length > 0) {
            buttonTag.setActions(null);
            tagsModified = true;
        }
        return tagsModified;
    }

    private String getAssociatedClass(ICharacterTag tag) {
        String associatedClass = "mx.core.SpriteAsset";
        if (tag instanceof DefineButtonTag) {
            associatedClass = "mx.core.ButtonAsset";
        } else if (tag instanceof DefineFontTag || tag instanceof DefineFont4Tag) {
            associatedClass = "mx.core.FontAsset";
        } else if (tag instanceof DefineTextTag) {
            associatedClass = "mx.core.TextFieldAsset";
        } else if (tag instanceof DefineSoundTag) {
            associatedClass = "mx.core.SoundAsset";
        } else if (tag instanceof DefineBitsTag || tag instanceof DefineBitsLosslessTag) {
            associatedClass = "mx.core.BitmapAsset";
        } else if (tag instanceof DefineSpriteTag) {
            associatedClass = "mx.core.SpriteAsset";
        }
        return associatedClass;
    }

    private DefineSpriteTag scaleExistingSprite(DefineSpriteTag sprite, Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        DefineScalingGridTag scalingGrid = this.buildScalingGrid();
        return this.buildSprite(sprite.getControlTags(), sprite.getFrameCount(), scalingGrid, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MovieTranscoder)) {
            return false;
        }
        MovieTranscoder t = (MovieTranscoder)o;
        return this.symbol != null ? this.symbol.equals(t.symbol) : t.symbol == null;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.symbol != null) {
            hashCode ^= this.symbol.hashCode();
        }
        return hashCode;
    }
}

