/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions.references;

import java.util.ArrayList;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.references.IReferenceMName;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicalReference
implements IReferenceMName {
    private final String name;

    public LexicalReference(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<INamespaceDefinition> getNamespaceSet(ICompilerProject project, IASScope scope) {
        return ((ASScope)scope).getNamespaceSetForName(project, this.getName());
    }

    @Override
    public IDefinition resolve(ICompilerProject project, IASScope scope, DependencyType depencencyType, boolean canEscapeWith) {
        return ((ASScope)scope).findProperty(project, this.getName(), depencencyType, canEscapeWith);
    }

    @Override
    public String getDisplayString() {
        return this.name;
    }

    @Override
    public Name getMName(ICompilerProject project, IASScope scope) {
        Name n = null;
        Set<INamespaceDefinition> namespaceSet = ((ASScope)scope).getNamespaceSetForName(project, this.name);
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(namespaceSet.size());
        for (INamespaceDefinition namespace : namespaceSet) {
            ns_set.add(((NamespaceDefinition)namespace).resolveAETNamespace(project));
        }
        n = new Name(9, new Nsset(ns_set), this.name);
        return n;
    }

    public String toString() {
        return this.getName();
    }
}

