/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.definitions.MetadataDefinitionBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.metadata.IStyleTagNode;

public class StyleDefinition
extends MetadataDefinitionBase
implements IStyleDefinition {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String arrayType;
    private String[] enumeration = EMPTY_STRING_ARRAY;
    private String format;
    private String inherit;
    private String[] states = EMPTY_STRING_ARRAY;
    private String[] themes = EMPTY_STRING_ARRAY;
    private String minValue;
    private String minValueExclusive;
    private String maxValue;
    private String maxValueExclusive;

    public StyleDefinition(String name, IClassDefinition decoratedDefinition) {
        super(name, "Style", decoratedDefinition);
    }

    public IStyleTagNode getNode() {
        return (IStyleTagNode)super.getNode();
    }

    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    public ITypeDefinition resolveArrayType(ICompilerProject project) {
        assert (false);
        return null;
    }

    public String[] getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(String[] enumeration) {
        assert (enumeration != null);
        this.enumeration = enumeration;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isColor() {
        return this.format.equals("Color");
    }

    public String getInherit() {
        return this.inherit;
    }

    public void setInherit(String inherit) {
        this.inherit = inherit;
    }

    public boolean isInheriting() {
        return this.inherit != null && this.inherit.equals("yes");
    }

    public String[] getStates() {
        return this.states;
    }

    public void setStates(String[] states) {
        this.states = states;
    }

    public String[] getThemes() {
        return this.themes;
    }

    public void setThemes(String themes) {
        if (themes == null) {
            this.themes = new String[0];
        } else {
            Iterable split = Splitter.onPattern((String)"[,\\s]").trimResults().omitEmptyStrings().split((CharSequence)themes);
            this.themes = (String[])Iterables.toArray((Iterable)split, String.class);
        }
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMinValueExclusive() {
        return this.minValueExclusive;
    }

    public void setMinValueExclusive(String minValueExclusive) {
        this.minValueExclusive = minValueExclusive;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMaxValueExclusive() {
        return this.maxValueExclusive;
    }

    public void setMaxValueExclusive(String maxValueExclusive) {
        this.maxValueExclusive = maxValueExclusive;
    }
}

