/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.databinding;

import java.util.Collection;
import java.util.List;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IScopedDefinition;
import org.apache.royale.compiler.internal.codegen.databinding.PropertyWatcherInfo;
import org.apache.royale.compiler.internal.codegen.databinding.WatcherInfoBase;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.tree.as.IASNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticPropertyWatcherInfo
extends PropertyWatcherInfo {
    private Name containingClass = null;

    public StaticPropertyWatcherInfo(Collection<ICompilerProblem> problems, IASNode sourceNode, List<String> eventNames) {
        super(problems, sourceNode, eventNames);
        this.type = WatcherInfoBase.WatcherType.STATIC_PROPERTY;
    }

    public Name getContainingClass(ICompilerProject project) {
        assert (this.containingClass != null);
        return this.containingClass;
    }

    public void init(IDefinition definition, ICompilerProject project) {
        IASScope scope = definition.getContainingScope();
        IScopedDefinition sd = scope.getDefinition();
        if (sd instanceof DefinitionBase) {
            DefinitionBase db = (DefinitionBase)((Object)sd);
            this.containingClass = db.getMName(project);
        }
    }
}

