/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.mxml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.royale.compiler.codegen.ISourceMapEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.codegen.mxml.IMXMLEmitter;
import org.apache.royale.compiler.driver.js.IJSBackend;
import org.apache.royale.compiler.internal.codegen.js.JSFilterWriter;
import org.apache.royale.compiler.internal.codegen.js.JSWriter;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.visitor.as.IASBlockWalker;
import org.apache.royale.compiler.visitor.mxml.IMXMLBlockWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLWriter
extends JSWriter {
    public MXMLWriter(RoyaleJSProject project, List<ICompilerProblem> problems, ICompilationUnit compilationUnit, boolean enableDebug) {
        super(project, problems, compilationUnit, enableDebug);
    }

    @Override
    public void writeTo(OutputStream out, OutputStream sourceMapOut, File sourceMapFile) {
        IJSBackend backend = (IJSBackend)this.project.getBackend();
        JSFilterWriter writer = (JSFilterWriter)backend.createWriterBuffer(this.project);
        IJSEmitter asEmitter = (IJSEmitter)backend.createEmitter(writer);
        IASBlockWalker asBlockWalker = backend.createWalker(this.project, this.problems, asEmitter);
        IMXMLEmitter mxmlEmitter = backend.createMXMLEmitter(writer);
        IMXMLBlockWalker mxmlBlockWalker = backend.createMXMLWalker(this.project, this.problems, mxmlEmitter, asEmitter, asBlockWalker);
        asEmitter.setParentEmitter(mxmlEmitter);
        mxmlBlockWalker.visitCompilationUnit(this.compilationUnit);
        try {
            out.write(mxmlEmitter.postProcess(writer.toString()).getBytes("utf8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sourceMapOut != null) {
            String sourceMapFilePath = null;
            String sourceRoot = null;
            if (sourceMapFile != null) {
                sourceMapFilePath = sourceMapFile.getAbsolutePath();
                this.convertMappingSourcePathsToRelative((IMappingEmitter)((Object)mxmlEmitter), sourceMapFile);
            } else {
                sourceRoot = System.getProperty("user.dir");
                this.convertMappingSourcePathsToRelative((IMappingEmitter)((Object)mxmlEmitter), new File(sourceRoot, "test.js.map"));
                sourceRoot = this.convertSourcePathToURI(sourceRoot);
            }
            this.convertMappingSourcePathsToURI((IMappingEmitter)((Object)mxmlEmitter));
            File compilationUnitFile = new File(this.compilationUnit.getAbsoluteFilename());
            ISourceMapEmitter sourceMapEmitter = backend.createSourceMapEmitter((IMappingEmitter)((Object)mxmlEmitter));
            try {
                String fileName = compilationUnitFile.getName();
                fileName = fileName.replace(".mxml", ".js");
                String sourceMap = sourceMapEmitter.emitSourceMap(fileName, sourceMapFilePath, sourceRoot);
                sourceMapOut.write(sourceMap.getBytes("utf8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

