/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLiteralValuePairEmitter
extends JSSubEmitter
implements ISubEmitter<IObjectLiteralValuePairNode> {
    public ObjectLiteralValuePairEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IObjectLiteralValuePairNode node) {
        ISourceLocation location = (ISourceLocation)node;
        boolean dynamicAccessUnknownMembers = false;
        ICompilerProject project = this.getProject();
        if (project instanceof RoyaleJSProject) {
            RoyaleJSProject fjsProject = (RoyaleJSProject)project;
            if (fjsProject.config != null) {
                dynamicAccessUnknownMembers = fjsProject.config.getJsDynamicAccessUnknownMembers();
            }
        }
        IExpressionNode nameNode = node.getNameNode();
        if (dynamicAccessUnknownMembers && nameNode instanceof IIdentifierNode) {
            IIdentifierNode identifierNode = (IIdentifierNode)nameNode;
            this.startMapping(location, (ISourceLocation)nameNode);
            this.write(ASEmitterTokens.DOUBLE_QUOTE);
            this.write(identifierNode.getName());
            this.write(ASEmitterTokens.DOUBLE_QUOTE);
            this.endMapping(location);
        } else {
            this.getWalker().walk((IASNode)nameNode);
        }
        this.startMapping(location, (ISourceLocation)nameNode);
        this.write(ASEmitterTokens.COLON);
        this.endMapping(location);
        IExpressionNode valueNode = node.getValueNode();
        this.getWalker().walk((IASNode)valueNode);
    }
}

