/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodEmitter
extends JSSubEmitter
implements ISubEmitter<IFunctionNode> {
    public MethodEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IFunctionNode node) {
        this.getModel().getMethods().add(node);
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        FunctionNode fn = (FunctionNode)node;
        fn.parseFunctionBody(new ArrayList());
        ICompilerProject project = this.getWalker().getProject();
        fjs.getDocEmitter().emitMethodDoc(node, project);
        boolean isConstructor = node.isConstructor();
        boolean addingBindableImplementsSupport = isConstructor && this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
        boolean addingBindableExtendsSupport = !addingBindableImplementsSupport && isConstructor && this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS;
        String qname = null;
        IFunctionDefinition.FunctionClassification classification = fn.getFunctionClassification();
        if (classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER || classification == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER) {
            this.write(fjs.formatQualifiedName(fn.getQualifiedName()));
        } else {
            this.startMapping((ISourceLocation)node.getNameExpressionNode());
            ITypeDefinition typeDef = EmitterUtils.getTypeDefinition((IDefinitionNode)node);
            if (typeDef != null) {
                qname = typeDef.getQualifiedName();
            }
            if (qname != null && !qname.equals("")) {
                this.write(fjs.formatQualifiedName(qname));
                if (!isConstructor) {
                    if (!fn.hasModifier(ASModifier.STATIC)) {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                        this.write(JSEmitterTokens.PROTOTYPE);
                    }
                    if (!fjs.isCustomNamespace(fn)) {
                        this.write(ASEmitterTokens.MEMBER_ACCESS);
                    }
                }
            }
            if (!isConstructor) {
                fjs.emitMemberName((IDefinitionNode)node);
            }
            this.endMapping((ISourceLocation)node.getNameExpressionNode());
        }
        if (node.getMetaTags() != null) {
            this.startMapping((ISourceLocation)node.getChild(1));
        } else {
            this.startMapping((ISourceLocation)node);
        }
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(ASEmitterTokens.FUNCTION);
        this.endMapping((ISourceLocation)node);
        fjs.emitParameters(node.getParametersContainerNode());
        boolean hasSuperClass = EmitterUtils.hasSuperClass(project, (IDefinitionNode)node);
        if (isConstructor && node.getScopedNode().getChildCount() == 0) {
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            if (hasSuperClass && !this.getEmitter().getModel().isExterns) {
                fjs.emitSuperCall((IASNode)node, "emptyConstructor");
            }
            if (addingBindableImplementsSupport) {
                this.writeNewline("", true);
                fjs.getBindableEmitter().emitBindableImplementsConstructorCode(true);
            } else if (addingBindableExtendsSupport) {
                IClassDefinition classDefinition = (IClassDefinition)node.getDefinition().getAncestorOfType(IClassDefinition.class);
                fjs.getBindableEmitter().emitBindableExtendsConstructorCode(classDefinition.getQualifiedName(), true);
            } else {
                this.writeNewline();
            }
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            fjs.emitComplexInitializers(cnode);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        if (!isConstructor || node.getScopedNode().getChildCount() > 0) {
            fjs.emitMethodScope(node.getScopedNode());
        }
        if (isConstructor && !this.getEmitter().getModel().isExterns) {
            if (hasSuperClass) {
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.write(JSGoogEmitterTokens.GOOG_INHERITS);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(fjs.formatQualifiedName(qname));
                this.writeToken(ASEmitterTokens.COMMA);
                String sname = EmitterUtils.getSuperClassDefinition((IDefinitionNode)node, project).getQualifiedName();
                this.write(fjs.formatQualifiedName(sname));
                this.write(ASEmitterTokens.PAREN_CLOSE);
            } else if (addingBindableExtendsSupport) {
                this.writeNewline(ASEmitterTokens.SEMICOLON);
                this.writeNewline("// Compiler generated Binding support implementation:");
                this.write(JSGoogEmitterTokens.GOOG_INHERITS);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(fjs.formatQualifiedName(qname));
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(fjs.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME));
                this.write(ASEmitterTokens.PAREN_CLOSE);
            }
        }
    }
}

