/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.asdoc.royale;

import antlr.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.asdoc.IASDocComment;
import org.apache.royale.compiler.asdoc.IASDocTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASDocComment
implements IASDocComment {
    Token token;
    private String description = null;
    private Map<String, List<IASDocTag>> tagMap;

    public ASDocComment(Token t) {
        this.token = t;
    }

    public String commentNoEnd() {
        int c;
        String s = this.token.getText();
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        int n = lines.length;
        if (n == 1 && (c = lines[0].indexOf("*/")) != -1) {
            lines[0] = lines[0].substring(0, c);
        }
        sb.append(lines[0]);
        sb.append("\n");
        for (int i = 1; i < n - 1; ++i) {
            String line = lines[i];
            int star = line.indexOf("*");
            sb.append(" ");
            if (star > -1) {
                sb.append(line.substring(star));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getDescription() {
        return this.description;
    }

    public void compile() {
        this.compile(true);
    }

    public void compile(boolean trimlines) {
        int c;
        String s = this.token.getText();
        String[] lines = s.split("\n");
        StringBuilder sb = new StringBuilder();
        int n = lines.length;
        if (n == 1 && (c = lines[0].indexOf("*/")) != -1) {
            lines[0] = lines[0].substring(0, c);
        }
        String line = lines[0].substring(3);
        if (trimlines) {
            sb.append(line.trim());
        } else {
            sb.append(line + "\n");
        }
        for (int i = 1; i < n - 1; ++i) {
            line = lines[i];
            int star = line.indexOf("*");
            int at = line.indexOf("@");
            if (at == -1) {
                sb.append(" ");
                if (star <= -1) continue;
                if (trimlines) {
                    sb.append(line.substring(star + 1).trim());
                    continue;
                }
                sb.append(line.substring(star + 1) + "\n");
                continue;
            }
            if (this.tagMap == null) {
                this.tagMap = new HashMap<String, List<IASDocTag>>();
            }
            int after = line.indexOf(" ", at + 1);
            int tabAfter = line.indexOf("\t", at + 1);
            if (tabAfter != -1 && after != -1 && tabAfter < after) {
                after = tabAfter;
            }
            if (after == -1) {
                this.tagMap.put(line.substring(at + 1), null);
                continue;
            }
            String tagName = line.substring(at + 1, after);
            List<IASDocTag> tags = this.tagMap.get(tagName);
            if (tags == null) {
                tags = new ArrayList<IASDocTag>();
                this.tagMap.put(tagName, tags);
            }
            tags.add(new ASDocTag(tagName, line.substring(after + 1).trim()));
        }
        this.description = trimlines ? sb.toString().trim().replace("\"", "\\\"") : sb.toString();
    }

    public boolean hasTag(String name) {
        if (this.tagMap == null) {
            return false;
        }
        return this.tagMap.containsKey(name);
    }

    public IASDocTag getTag(String name) {
        if (this.tagMap == null) {
            return null;
        }
        List<IASDocTag> tags = this.tagMap.get(name);
        if (tags == null) {
            return null;
        }
        return tags.get(0);
    }

    public Map<String, List<IASDocTag>> getTags() {
        return this.tagMap;
    }

    public Collection<IASDocTag> getTagsByName(String string) {
        return this.tagMap.get(string);
    }

    public void paste(IASDocComment source) {
    }

    class ASDocTag
    implements IASDocTag {
        private String name;
        private String desc;

        public ASDocTag(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean hasDescription() {
            return this.desc != null;
        }
    }
}

