/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.headless;

import java.io.IOException;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.Command;
import org.apache.royale.test.ant.launcher.commands.headless.XvncException;

public class XvncStartCommand
extends Command {
    private final String VNC_SERVER_COMMAND = "vncserver";
    private final int MAX_DISPLAY_CYCLES = 2;
    private int baseDisplay;
    private int currentDisplay;

    public XvncStartCommand(int display) {
        this.baseDisplay = display;
        this.currentDisplay = display;
    }

    public void cycle() throws XvncException {
        if (this.currentDisplay - this.baseDisplay == 2) {
            throw new XvncException(this.baseDisplay, this.currentDisplay);
        }
        ++this.currentDisplay;
    }

    public int getCurrentDisplay() {
        return this.currentDisplay;
    }

    public int execute() throws IOException {
        this.getCommandLine().setExecutable("vncserver");
        this.getCommandLine().addArguments(new String[]{":" + String.valueOf(this.currentDisplay)});
        LoggingUtil.log("Attempting start on :" + this.currentDisplay + " ...");
        return super.execute();
    }
}

