/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swc.catalog;

import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLFormatter
implements XMLStreamWriter {
    private static final Integer STATE_START = 0;
    private static final Integer STATE_IN_ELEMENT = 1;
    private static final Integer STATE_IN_DATA = 2;
    private static final String INDENT_STRING = "    ";
    private static final String LINE_ENDING_STRING = "\n";
    private final XMLStreamWriter writer;
    private int depth = 0;
    private final Stack<Integer> states;
    private Integer currentState = STATE_START;

    public XMLFormatter(XMLStreamWriter writer) {
        this.writer = writer;
        this.states = new Stack();
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }

    private void onEmptyElement() throws XMLStreamException {
        this.currentState = STATE_IN_ELEMENT;
        if (this.depth > 0) {
            this.writeLineEnding();
        }
        this.writeIndentString();
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (this.currentState == STATE_IN_ELEMENT) {
            this.writeLineEnding();
            this.writeIndentString();
        }
        this.currentState = this.states.pop();
    }

    private void onStartElement() throws XMLStreamException {
        this.states.push(STATE_IN_ELEMENT);
        this.currentState = STATE_START;
        if (this.depth > 0) {
            this.writeLineEnding();
        }
        this.writeIndentString();
        ++this.depth;
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeCData(String data) throws XMLStreamException {
        this.currentState = STATE_IN_DATA;
        this.writer.writeCData(data);
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.currentState = STATE_IN_DATA;
        this.writer.writeCharacters(text, start, len);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.currentState = STATE_IN_DATA;
        this.writer.writeCharacters(text);
    }

    public void writeComment(String data) throws XMLStreamException {
        this.writer.writeComment(data);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(localName);
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(namespaceURI, localName);
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        this.writer.writeEndElement();
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    private void writeIndentString() throws XMLStreamException {
        if (this.depth > 0) {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.writeCharacters(INDENT_STRING);
            }
        }
    }

    private void writeLineEnding() throws XMLStreamException {
        this.writer.writeCharacters(LINE_ENDING_STRING);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writeLineEnding();
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
        this.writeLineEnding();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        this.writeLineEnding();
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(localName);
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(namespaceURI, localName);
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
    }
}

