/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.royale.compiler.internal.parsing.as.OffsetCue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetLookup {
    private static final Comparator<OffsetCue> OFFSET_CUE_COMPARATOR = new Comparator<OffsetCue>(){

        @Override
        public int compare(OffsetCue o1, OffsetCue o2) {
            return o1.absolute - o2.absolute;
        }
    };
    private static final Ordering<OffsetCue> ORDER_BY_ABSOLUTE = Ordering.from(OFFSET_CUE_COMPARATOR);
    private final ImmutableList<OffsetCue> offsetCueList;

    private static OffsetCue createSearchKey(int absolute) {
        return new OffsetCue("", absolute, 0);
    }

    public OffsetLookup(ImmutableList<OffsetCue> offsetCueList) {
        assert (offsetCueList != null) : "Offset cue list can't be null.";
        assert (ORDER_BY_ABSOLUTE.isOrdered(offsetCueList)) : "Offset cue list should be sorted by absolute offset.";
        this.offsetCueList = offsetCueList;
    }

    private OffsetCue findOffsetCue(int absoluteOffset) {
        if (this.offsetCueList.isEmpty() || absoluteOffset < 0) {
            return null;
        }
        OffsetCue key = OffsetLookup.createSearchKey(absoluteOffset);
        int index = ORDER_BY_ABSOLUTE.binarySearch(this.offsetCueList, key);
        if (index >= 0) {
            return (OffsetCue)this.offsetCueList.get(index);
        }
        int insertionPoint = -(index + 1);
        return (OffsetCue)this.offsetCueList.get(insertionPoint - 1);
    }

    public String getFilename(int absoluteOffset) {
        OffsetCue result = this.findOffsetCue(absoluteOffset);
        if (result == null) {
            return null;
        }
        return result.filename;
    }

    public int getLocalOffset(int absoluteOffset) {
        OffsetCue result = this.findOffsetCue(absoluteOffset);
        if (result == null) {
            return absoluteOffset;
        }
        return absoluteOffset - result.adjustment;
    }

    public int[] getAbsoluteOffset(final String filename, int localOffset) {
        if (this.offsetCueList.isEmpty()) {
            return new int[]{localOffset};
        }
        assert (filename != null) : "Filename can't be null.";
        if (localOffset < 0) {
            return new int[]{localOffset};
        }
        Iterable<OffsetCue> fileOffsetCueList = Iterables.filter(this.offsetCueList, new Predicate<OffsetCue>(){

            @Override
            public boolean apply(OffsetCue cue) {
                return cue.filename.equals(filename);
            }

            @Override
            public boolean test(OffsetCue input) {
                return this.apply(input);
            }
        });
        ArrayList<OffsetCue> candidateCues = new ArrayList<OffsetCue>(1);
        OffsetCue candidate = null;
        for (OffsetCue cue : fileOffsetCueList) {
            if (cue.local <= localOffset) {
                candidate = cue;
                continue;
            }
            if (candidate == null) continue;
            candidateCues.add(candidate);
            candidate = null;
        }
        if (candidate != null) {
            candidateCues.add(candidate);
        }
        if (candidateCues.isEmpty()) {
            throw new IllegalArgumentException("Local offset '" + localOffset + "' is not in file " + filename);
        }
        int matchSize = candidateCues.size();
        int[] absoluteOffsets = new int[matchSize];
        for (int i = 0; i < matchSize; ++i) {
            OffsetCue cue = (OffsetCue)candidateCues.get(i);
            absoluteOffsets[i] = cue.absolute + (localOffset - cue.local);
        }
        return absoluteOffsets;
    }

    public String toString() {
        return Joiner.on("\n").join(this.offsetCueList);
    }

    public boolean hasIncludes() {
        return this.offsetCueList.size() > 1;
    }
}

