/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.launcher.commands.player;

import java.io.File;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.launcher.commands.player.DefaultPlayerCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.URLResource;
import org.apache.tools.ant.util.ResourceUtils;

public class AdlCommand
extends DefaultPlayerCommand {
    private final String ADT_JAR_PATH = "lib" + File.separatorChar + "adt.jar";
    private final String DESCRIPTOR_TEMPLATE = "royaleUnitDescriptor.template";
    private final String DESCRIPTOR_FILE = "royaleUnitDescriptor.xml";
    private File precompiledAppDescriptor;

    public File getFileToExecute() {
        if (this.getPrecompiledAppDescriptor() != null) {
            return new File(this.getPrecompiledAppDescriptor().getAbsolutePath());
        }
        return new File(this.getSwf().getParentFile().getAbsolutePath() + File.separatorChar + "royaleUnitDescriptor.xml");
    }

    private void createApplicationDescriptor() {
        try {
            URLResource template = new URLResource(this.getClass().getResource("/royaleUnitDescriptor.template"));
            File descriptor = new File(this.getSwf().getParentFile().getAbsolutePath() + File.separatorChar + "royaleUnitDescriptor.xml");
            Double versionNumber = this.getVersion();
            FilterSet filters = new FilterSet();
            filters.addFilter("ADL_SWF", this.getSwf().getName());
            filters.addFilter("ADT_VERSION", Double.toString(versionNumber));
            if (versionNumber > 2.0) {
                filters.addFilter("VERSION_PROP", "versionNumber");
            } else {
                filters.addFilter("VERSION_PROP", "version");
            }
            ResourceUtils.copyResource((Resource)template, (Resource)new FileResource(descriptor), (FilterSetCollection)new FilterSetCollection(filters), null, (boolean)true, (boolean)false, null, null, (Project)this.getProject());
            LoggingUtil.log("Created application descriptor at [" + descriptor.getAbsolutePath() + "]");
        }
        catch (Exception e) {
            throw new BuildException("Could not create application descriptor");
        }
    }

    private double getVersion() {
        String outputProperty = "AIR_VERSION";
        Java task = new Java();
        task.setFork(true);
        task.setFailonerror(true);
        task.setJar(new File(this.getProject().getProperty("ROYALE_HOME") + File.separatorChar + this.ADT_JAR_PATH));
        task.setProject(this.getProject());
        task.setDir(this.getProject().getBaseDir());
        task.setOutputproperty(outputProperty);
        Commandline.Argument versionArgument = task.createArg();
        versionArgument.setValue("-version");
        task.execute();
        double version = this.parseAdtVersionNumber(this.getProject().getProperty(outputProperty));
        LoggingUtil.log("Found AIR version: " + version);
        return version;
    }

    private double parseAdtVersionNumber(String versionString) {
        double version;
        if (versionString.startsWith("adt")) {
            int prefixIndex = versionString.indexOf("adt version \"");
            version = Double.parseDouble(versionString.substring(prefixIndex + 13, prefixIndex + 16));
        } else {
            version = Double.parseDouble(versionString.substring(0, 3));
        }
        return version;
    }

    public void prepare() {
        this.getCommandLine().setExecutable(this.generateExecutable());
        this.getCommandLine().addArguments(new String[]{this.getFileToExecute().getAbsolutePath()});
        if (this.getPrecompiledAppDescriptor() == null) {
            this.createApplicationDescriptor();
        }
    }

    private String generateExecutable() {
        return this.getProject().getProperty("ROYALE_HOME") + "/bin/" + this.getDefaults().getAdlCommand();
    }

    public File getPrecompiledAppDescriptor() {
        return this.precompiledAppDescriptor;
    }

    public void setPrecompiledAppDescriptor(File precompiledAppDescriptor) {
        this.precompiledAppDescriptor = precompiledAppDescriptor;
    }
}

