/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.tags;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.royale.swf.TagType;
import org.apache.royale.swf.tags.ICharacterReferrer;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.IManagedTag;
import org.apache.royale.swf.tags.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAssetsTag
extends Tag
implements IManagedTag,
ICharacterReferrer {
    private final Map<String, ICharacterTag> exports = new LinkedHashMap<String, ICharacterTag>();

    public ExportAssetsTag() {
        super(TagType.ExportAssets);
    }

    public Set<String> getCharacterNames() {
        return this.exports.keySet();
    }

    public ICharacterTag getCharacterTagByName(String name) {
        return this.exports.get(name);
    }

    public void addExport(ICharacterTag characterTag, String name) {
        assert (characterTag != null);
        this.removeExport(characterTag);
        this.exports.put(name, characterTag);
    }

    private final String findNameByCharacterTag(ICharacterTag characterTag) {
        String name = null;
        for (String key : this.exports.keySet()) {
            if (this.exports.get(key) != characterTag) continue;
            name = key;
            break;
        }
        return name;
    }

    public void removeExport(ICharacterTag characterTag) {
        String name = this.findNameByCharacterTag(characterTag);
        if (name != null) {
            this.exports.remove(name);
        }
    }

    public void removeExport(String name) {
        this.exports.remove(name);
    }

    public int size() {
        return this.exports.size();
    }

    @Override
    public String description() {
        StringBuilder buffer = new StringBuilder();
        for (String name : this.exports.keySet()) {
            ICharacterTag tag = this.exports.get(name);
            buffer.append(String.format("(%s:%s#%d) ", new Object[]{name, tag.getTagType(), tag.getCharacterID()}));
        }
        return buffer.toString();
    }

    @Override
    public Iterable<ICharacterTag> getReferences() {
        return this.exports.values();
    }
}

