/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.internal.mxml.MXMLDialect2006;
import org.apache.royale.compiler.internal.mxml.MXMLDialect2009;
import org.apache.royale.compiler.internal.mxml.MXMLDialect2012;
import org.apache.royale.compiler.projects.ICompilerProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MXMLDialect {
    public static final MXMLDialect MXML_2012 = MXMLDialect2012.getInstance();
    public static final MXMLDialect MXML_2009 = MXMLDialect2009.getInstance();
    public static final MXMLDialect MXML_2006 = MXMLDialect2006.getInstance();
    public static final MXMLDialect DEFAULT = MXML_2009;
    private static final Map<String, MXMLDialect> DIALECT_MAP = new ImmutableMap.Builder<String, MXMLDialect>().put(MXML_2006.getLanguageNamespace(), MXML_2006).put(MXML_2009.getLanguageNamespace(), MXML_2009).put(MXML_2012.getLanguageNamespace(), MXML_2012).build();
    private static final Map<String, Character> NAMED_ENTITY_MAP = new ImmutableMap.Builder<String, Character>().put("amp", Character.valueOf('&')).put("apos", Character.valueOf('\'')).put("gt", Character.valueOf('>')).put("lt", Character.valueOf('<')).put("quot", Character.valueOf('\"')).put("nbsp", Character.valueOf(' ')).build();
    private final String languageNamespace;
    private final int year;
    private final XMLName arrayXMLName;
    private final XMLName booleanXMLName;
    private final XMLName classXMLName;
    private final XMLName dateXMLName;
    private final XMLName functionXMLName;
    private final XMLName intXMLName;
    private final XMLName numberXMLName;
    private final XMLName objectXMLName;
    private final XMLName stringXMLName;
    private final XMLName uintXMLName;
    private final XMLName xmlXMLName;
    private final XMLName xmlListXMLName;
    protected XMLName bindingXMLName;
    protected XMLName componentXMLName;
    protected XMLName declarationsXMLName;
    protected XMLName definitionXMLName;
    protected XMLName libraryXMLName;
    protected XMLName metadataXMLName;
    protected XMLName modelXMLName;
    protected XMLName privateXMLName;
    protected XMLName reparentXMLName;
    protected XMLName scriptXMLName;
    protected XMLName styleXMLName;

    public static boolean isLanguageNamespace(String uri) {
        return DIALECT_MAP.containsKey(uri);
    }

    public static MXMLDialect getDialectForLanguageNamespace(String uri) {
        return DIALECT_MAP.get(uri);
    }

    public static MXMLDialect getMXMLDialect(PrefixMap rootPrefixMap) {
        for (String prefix : rootPrefixMap.getAllPrefixes()) {
            String ns = rootPrefixMap.getNamespaceForPrefix(prefix);
            if (!MXMLDialect.isLanguageNamespace(ns)) continue;
            return MXMLDialect.getDialectForLanguageNamespace(ns);
        }
        return DEFAULT;
    }

    protected MXMLDialect(String languageNamespace, int year) {
        this.languageNamespace = languageNamespace;
        this.year = year;
        this.arrayXMLName = new XMLName(languageNamespace, "Array");
        this.booleanXMLName = new XMLName(languageNamespace, "Boolean");
        this.classXMLName = new XMLName(languageNamespace, "Class");
        this.dateXMLName = new XMLName(languageNamespace, "Date");
        this.functionXMLName = new XMLName(languageNamespace, "Function");
        this.intXMLName = new XMLName(languageNamespace, "int");
        this.numberXMLName = new XMLName(languageNamespace, "Number");
        this.objectXMLName = new XMLName(languageNamespace, "Object");
        this.stringXMLName = new XMLName(languageNamespace, "String");
        this.uintXMLName = new XMLName(languageNamespace, "uint");
        this.xmlXMLName = new XMLName(languageNamespace, "XML");
        this.xmlListXMLName = new XMLName(languageNamespace, "XMLList");
    }

    public String getLanguageNamespace() {
        return this.languageNamespace;
    }

    public boolean isEqualToOrAfter(MXMLDialect other) {
        return this.year >= other.year;
    }

    public boolean isEqualToOrBefore(MXMLDialect other) {
        return this.year <= other.year;
    }

    public XMLName resolveArray() {
        return this.arrayXMLName;
    }

    public XMLName resolveBinding() {
        return this.bindingXMLName;
    }

    public XMLName resolveBoolean() {
        return this.booleanXMLName;
    }

    public XMLName resolveClass() {
        return this.classXMLName;
    }

    public XMLName resolveComponent() {
        return this.componentXMLName;
    }

    public XMLName resolveDeclarations() {
        return this.declarationsXMLName;
    }

    public XMLName resolveDate() {
        return this.dateXMLName;
    }

    public XMLName resolveDefinition() {
        return this.definitionXMLName;
    }

    public XMLName resolveFunction() {
        return this.functionXMLName;
    }

    public XMLName resolveInt() {
        return this.intXMLName;
    }

    public XMLName resolveLibrary() {
        return this.libraryXMLName;
    }

    public XMLName resolveMetadata() {
        return this.metadataXMLName;
    }

    public XMLName resolveModel() {
        return this.modelXMLName;
    }

    public XMLName resolveNumber() {
        return this.numberXMLName;
    }

    public XMLName resolveObject() {
        return this.objectXMLName;
    }

    public XMLName resolvePrivate() {
        return this.privateXMLName;
    }

    public XMLName resolveReparent() {
        return this.reparentXMLName;
    }

    public XMLName resolveScript() {
        return this.scriptXMLName;
    }

    public XMLName resolveString() {
        return this.stringXMLName;
    }

    public XMLName resolveStyle() {
        return this.styleXMLName;
    }

    public XMLName resolveUint() {
        return this.uintXMLName;
    }

    public XMLName resolveXML() {
        return this.xmlXMLName;
    }

    public XMLName resolveXMLList() {
        return this.xmlListXMLName;
    }

    public Character getNamedEntity(String entityName) {
        return NAMED_ENTITY_MAP.get(entityName);
    }

    public abstract boolean isWhitespace(char var1);

    public abstract boolean isWhitespace(String var1);

    public abstract String collapseWhitespace(String var1, char var2);

    public abstract String trim(String var1);

    public abstract String[] splitAndTrim(String var1);

    public abstract Boolean parseBoolean(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract Integer parseInt(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract Long parseUint(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract Number parseNumber(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract String parseString(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract List<Object> parseArray(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    public abstract Object parseObject(ICompilerProject var1, String var2, EnumSet<TextParsingFlags> var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextParsingFlags {
        ALLOW_ARRAY,
        ALLOW_BINDING,
        ALLOW_COLOR_NAME,
        ALLOW_COMPILER_DIRECTIVE,
        ALLOW_ESCAPED_COMPILER_DIRECTIVE,
        ALLOW_PERCENT,
        COLLAPSE_WHITE_SPACE,
        RICH_TEXT_CONTENT;

    }
}

