/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.config;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.config.Configuration;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.config.RSLSettings;
import org.apache.royale.compiler.internal.config.FrameInfo;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.utils.FilenameNormalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetSettings
implements ITargetSettings {
    protected File output;
    protected File defaultCSS;
    protected List<File> themes;
    protected Collection<File> externalLibraryPath;
    protected Collection<File> includeLibraries;
    protected List<RSLSettings> rslLibraryPath;
    protected Set<File> includeSources;
    protected Map<String, File> includeFiles;
    protected final Configuration configuration;
    protected final ICompilerProject project;
    protected Set<String> externalLinkageLibraries;

    public TargetSettings(Configuration configuration, ICompilerProject project) {
        this.configuration = configuration;
        this.project = project;
    }

    @Override
    public boolean isAccessible() {
        return this.configuration.getCompilerAccessible();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.configuration.isDebuggingEnabled();
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.configuration.isEnableTelemetry();
    }

    @Override
    public boolean isOptimized() {
        return this.configuration.getCompilerOptimize();
    }

    @Override
    public boolean useCompression() {
        return this.configuration.useCompression();
    }

    @Override
    public boolean areVerboseStacktracesEnabled() {
        return this.configuration.debug();
    }

    @Override
    public boolean allowSubclassOverrides() {
        return this.configuration.getCompilerAllowSubclassOverrides();
    }

    @Override
    public boolean keepAllTypeSelectors() {
        return this.configuration.keepAllTypeSelectors();
    }

    @Override
    public boolean useNetwork() {
        return this.configuration.getUseNetwork();
    }

    @Override
    public boolean removeUnusedRuntimeSharedLibraryPaths() {
        return this.configuration.getRemoveUnusedRsls();
    }

    @Override
    public boolean verifyDigests() {
        return this.configuration.getVerifyDigests();
    }

    @Override
    public boolean useResourceBundleMetadata() {
        return true;
    }

    @Override
    public boolean isIncludeLookupOnlyEnabled() {
        return this.configuration.getIncludeLookupOnly();
    }

    @Override
    public int getDefaultBackgroundColor() {
        return this.configuration.getDefaultBackgroundColor();
    }

    @Override
    public int getDefaultFrameRate() {
        return this.configuration.getDefaultFrameRate();
    }

    @Override
    public boolean areDefaultScriptLimitsSet() {
        return this.configuration.scriptLimitsSet();
    }

    @Override
    public int getDefaultScriptTimeLimit() {
        return this.configuration.getScriptTimeLimit();
    }

    @Override
    public int getDefaultScriptRecursionLimit() {
        return this.configuration.getScriptRecursionLimit();
    }

    @Override
    public int getDefaultWidth() {
        return this.configuration.getDefaultWidth();
    }

    @Override
    public int getDefaultHeight() {
        return this.configuration.getDefaultHeight();
    }

    @Override
    public File getOutput() {
        if (this.output == null) {
            this.output = FilenameNormalization.normalize(new File(this.configuration.getOutput()));
        }
        return this.output;
    }

    @Override
    public Collection<String> getASMetadataNames() {
        return this.configuration.getCompilerKeepAs3Metadata();
    }

    @Override
    public File getDefaultCSS() {
        if (this.defaultCSS == null) {
            this.defaultCSS = FilenameNormalization.normalize(new File(this.configuration.getCompilerDefaultsCssUrl()));
        }
        return this.defaultCSS;
    }

    @Override
    public Collection<String> getExterns() {
        return this.configuration.getExterns();
    }

    @Override
    public String[] getMxmlImplicitImports() {
        return this.configuration.getCompilerMxmlImplicitImports();
    }

    @Override
    public Collection<String> getIncludes() {
        return this.configuration.getIncludes();
    }

    @Override
    public List<FrameInfo> getFrameLabels() {
        return this.configuration.getFrameList();
    }

    @Override
    public String getSWFMetadata() {
        return this.configuration.getRawMetadata();
    }

    @Override
    public int getSWFVersion() {
        return this.configuration.getSwfVersion();
    }

    @Override
    public String getPreloaderClassName() {
        return this.configuration.getPreloader();
    }

    @Override
    public String getRootSourceFileName() {
        return this.configuration.getTargetFile();
    }

    @Override
    public String getRootClassName() {
        return this.configuration.getMainDefinition();
    }

    @Override
    public List<File> getThemes() {
        if (this.themes == null) {
            this.themes = Configurator.toFileList(this.configuration.getCompilerThemeFiles());
        }
        return this.themes;
    }

    @Override
    public Collection<File> getExternalLibraryPath() {
        if (this.externalLibraryPath == null) {
            this.externalLibraryPath = Configurator.toFileList(this.configuration.getCompilerExternalLibraryPath());
        }
        return this.externalLibraryPath;
    }

    @Override
    public Collection<File> getIncludeLibraries() {
        if (this.includeLibraries == null) {
            this.includeLibraries = Configurator.toFileList(this.configuration.getCompilerIncludeLibraries());
        }
        return this.includeLibraries;
    }

    @Override
    public List<String> getRuntimeSharedLibraries() {
        return this.configuration.getRuntimeSharedLibraries();
    }

    @Override
    public List<RSLSettings> getRuntimeSharedLibraryPath() {
        if (this.rslLibraryPath == null) {
            this.rslLibraryPath = Configurator.getRSLSettingsFromConfiguration(this.configuration);
        }
        return this.rslLibraryPath;
    }

    @Override
    public Collection<String> getIncludeClasses() {
        return this.configuration.getIncludeClasses();
    }

    @Override
    public Collection<File> getIncludeSources() {
        if (this.includeSources == null) {
            this.includeSources = new HashSet<File>();
            List<File> files = Configurator.toFileList(this.configuration.getIncludeSources());
            for (File file : files) {
                if (file.isFile()) {
                    this.includeSources.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                for (File fileInFolder : FileUtils.listFiles(file, new String[]{"as", "mxml"}, true)) {
                    this.includeSources.add(fileInFolder);
                }
            }
        }
        return this.includeSources;
    }

    @Override
    public Map<String, File> getIncludeFiles() {
        if (this.includeFiles == null) {
            this.includeFiles = new TreeMap<String, File>();
            for (Map.Entry<String, String> fileEntry : this.configuration.getIncludeFiles().entrySet()) {
                this.includeFiles.put(fileEntry.getKey(), FilenameNormalization.normalize(new File(fileEntry.getValue())));
            }
        }
        return this.includeFiles;
    }

    @Override
    public Collection<String> getIncludeNamespaces() {
        return this.configuration.getIncludeNamespaces();
    }

    @Override
    public Collection<String> getIncludeResourceBundles() {
        return this.configuration.getIncludeResourceBundles();
    }

    @Override
    public Map<String, File> getIncludeStyleSheets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLinkageExternal(String path) {
        if (this.externalLinkageLibraries == null) {
            this.initExternalLinkageLibraries();
        }
        return this.externalLinkageLibraries.contains(path);
    }

    @Override
    public boolean useDirectBlit() {
        return false;
    }

    @Override
    public boolean useGPU() {
        return false;
    }

    private void initExternalLinkageLibraries() {
        this.externalLinkageLibraries = new HashSet<String>(this.getExternalLibraryPath().size() + this.getRuntimeSharedLibraryPath().size());
        for (File library : this.getExternalLibraryPath()) {
            this.externalLinkageLibraries.add(library.getAbsolutePath());
        }
        for (RSLSettings rsl : this.getRuntimeSharedLibraryPath()) {
            this.externalLinkageLibraries.add(rsl.getLibraryFile().getAbsolutePath());
        }
    }

    @Override
    public List<String> getDefaultsCSSFiles() {
        return ImmutableList.copyOf(this.configuration.getDefaultsCSSFiles());
    }

    @Override
    public List<String> getExcludeDefaultsCSSFiles() {
        return ImmutableList.copyOf(this.configuration.getExcludeDefaultsCSSFiles());
    }

    @Override
    public File getLinkReport() {
        return this.configuration.getLinkReport();
    }

    @Override
    public File getSizeReport() {
        return this.configuration.getSizeReport();
    }

    @Override
    public String getRoyaleMinimumSupportedVersion() {
        return this.configuration.getCompilerMinimumSupportedVersionString();
    }

    @Override
    public boolean getMxmlChildrenAsData() {
        return this.configuration.getCompilerMxmlChildrenAsData();
    }

    @Override
    public boolean getInfoFlex() {
        return this.configuration.getCompilerInfoFlex();
    }

    @Override
    public boolean getAllowSubclassOverrides() {
        return this.configuration.getCompilerAllowSubclassOverrides();
    }

    @Override
    public boolean getRemoveDeadCode() {
        return this.configuration.getRemoveDeadCode();
    }

    @Override
    public String getSWFMetadataDate() {
        return this.configuration.getMetadataDate();
    }

    @Override
    public String getSWFMetadataDateFormat() {
        return this.configuration.getMetadataDateFormat();
    }
}

