/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentUtil {
    public static String[] fixArgs(String[] args) {
        String targetPath;
        String[] newArgs = args;
        if (args.length > 1 && (targetPath = args[args.length - 1]).startsWith(".")) {
            if ((CompilerDiagnosticsConstants.diagnostics & 0x1000) == 4096) {
                System.out.println("ArgumentUtil waiting for lock in getTheRealPathBecauseCanonicalizeDoesNotFixCase");
            }
            targetPath = FileUtils.getTheRealPathBecauseCanonicalizeDoesNotFixCase(new File(targetPath));
            if ((CompilerDiagnosticsConstants.diagnostics & 0x1000) == 4096) {
                System.out.println("ArgumentUtil waiting for lock in getTheRealPathBecauseCanonicalizeDoesNotFixCase");
            }
            newArgs = new String[args.length];
            System.arraycopy(args, 0, newArgs, 0, args.length - 1);
            newArgs[args.length - 1] = targetPath;
        }
        return newArgs;
    }

    public static String[] removeEachElement(String[] args, String element) {
        String[] newArgs = (String[])args.clone();
        while (ArgumentUtil.getValue(newArgs, element) != null) {
            newArgs = ArgumentUtil.removeElement(args, element);
        }
        return newArgs;
    }

    public static String[] removeElement(String[] args, String element) {
        int length = Array.getLength(args);
        int index = -1;
        for (int i = 0; i < length; ++i) {
            boolean plusEqual = args[i].contains("+=");
            String[] kvp = args[i].split(plusEqual ? "\\+=" : "=");
            if (!element.equals(kvp[0])) continue;
            index = i;
            break;
        }
        String[] newArgs = new String[length - 1];
        if (index < 0 || index >= length) {
            System.arraycopy(args, 0, newArgs, 0, length - 1);
        } else {
            System.arraycopy(args, 0, newArgs, 0, index);
            if (index < length - 1) {
                System.arraycopy(args, index + 1, newArgs, index, length - index - 1);
            }
        }
        return newArgs;
    }

    public static String[] removeElementWithValue(String[] args, String element, String value) {
        int length = Array.getLength(args);
        int index = -1;
        for (int i = 0; i < length; ++i) {
            boolean plusEqual = args[i].contains("+=");
            String[] kvp = args[i].split(plusEqual ? "\\+=" : "=");
            if (!element.equals(kvp[0]) || kvp.length != 1 && (value == null || !value.equals(kvp[1]))) continue;
            index = i;
            break;
        }
        String[] newArgs = new String[length - 1];
        if (index < 0 || index >= length) {
            System.arraycopy(args, 0, newArgs, 0, length - 1);
        } else {
            System.arraycopy(args, 0, newArgs, 0, index);
            if (index < length - 1) {
                System.arraycopy(args, index + 1, newArgs, index, length - index - 1);
            }
        }
        return newArgs;
    }

    public static String getValue(String[] args, String element) {
        boolean found = false;
        String[] kvp = new String[]{};
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            boolean plusEqual = (s = stringArray[i]).contains("+=");
            kvp = s.split(plusEqual ? "\\+=" : "=");
            if (!kvp[0].equals(element)) continue;
            found = true;
            break;
        }
        return found ? (kvp.length == 2 ? kvp[1] : null) : null;
    }

    public static Collection<String> getValues(String[] args, String element) {
        ArrayListMultimap argsMap = ArrayListMultimap.create();
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s;
            boolean plusEqual = (s = stringArray[i]).contains("+=");
            String[] kvp = s.split(plusEqual ? "\\+=" : "=");
            if (plusEqual || !argsMap.containsKey((Object)kvp[0])) {
                argsMap.put((Object)kvp[0], kvp.length == 2 ? kvp[1] : null);
                continue;
            }
            ArrayList<String> replacement = null;
            if (kvp.length <= 1) continue;
            replacement = new ArrayList<String>();
            replacement.add(kvp[1]);
            argsMap.replaceValues((Object)kvp[0], replacement);
        }
        return argsMap.get((Object)element);
    }

    public static void setValue(String[] args, String element, String value) {
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            boolean plusEqual = args[i].contains("+=");
            String[] kvp = args[i].split(plusEqual ? "\\+=" : "=");
            if (!kvp[0].equals(element)) continue;
            String affectationSign = plusEqual ? "+=" : "=";
            args[i] = kvp[0] + affectationSign + value;
            break;
        }
    }

    public static String[] addValue(String[] args, String element) {
        return ArgumentUtil.addValue(args, element, null, args.length - 1, false);
    }

    public static String[] addValue(String[] args, String element, String value) {
        return ArgumentUtil.addValue(args, element, value, args.length - 1, false);
    }

    public static String[] addValue(String[] args, String element, String value, boolean plusEqual) {
        return ArgumentUtil.addValue(args, element, value, args.length - 1, plusEqual);
    }

    public static String[] addValue(String[] args, String element, String value, int index) {
        return ArgumentUtil.addValue(args, element, value, index, false);
    }

    public static String[] addValue(String[] args, String element, String value, int index, boolean plusEqual) {
        int length = Array.getLength(args);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        String[] newArgs = new String[args.length + 1];
        for (int i = 0; i < newArgs.length; ++i) {
            if (i < index) {
                newArgs[i] = args[i];
                continue;
            }
            if (i == index) {
                String affectationSign = plusEqual ? "+=" : "=";
                newArgs[i] = value != null ? element + affectationSign + value : element;
                continue;
            }
            newArgs[i] = args[i - 1];
        }
        return newArgs;
    }
}

