/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.swf.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SizeReport {
    private int size;
    private int currentFrame = 1;
    private int currentFrameSize;
    private int compressedSize;
    private Map<Integer, String> symbols = new HashMap<Integer, String>();
    private Map<Integer, DefinitionData> definitionTypes = new HashMap<Integer, DefinitionData>();
    private String prevFrameLabel = null;
    public static final int BINARY = 0;
    public static final int BITMAP = 1;
    public static final int FONT = 2;
    public static final int FRAME = 3;
    public static final int FRAME_DATA = 4;
    public static final int HEADER_DATA = 5;
    public static final int SCRIPT = 6;
    public static final int SHAPE = 7;
    public static final int SOUND = 8;
    public static final int SPRITE = 9;
    public static final int VIDEO = 10;

    public SizeReport() {
        this.registerDefinitionType(0, "binaryData", "data", "SWF, Pixel Bender, or other miscellaneous embed data.");
        this.registerDefinitionType(1, "bitmaps", "bitmap", "defineBits, definebitsJPEG2/3/4, or defineBitsLossless/2");
        this.registerDefinitionType(2, "fonts", "font", "defineFont/2/3/4.");
        this.registerDefinitionType(3, "frames", "frame", "Cumulative frame size summary.");
        this.registerDefinitionType(4, "frameData", "tag", "Additional frame tags (symbolClass, exportAssets, showFrame, etc).");
        this.registerDefinitionType(5, "headerData", "data", "Header data (SWF attributes, product info, markers, etc.)");
        this.registerDefinitionType(6, "actionScript", "abc", "Actionscript code and constant data.");
        this.registerDefinitionType(7, "shapes", "shape", "defineShape/2/3/4.");
        this.registerDefinitionType(8, "sounds", "sound", "defineSound.");
        this.registerDefinitionType(9, "sprites", "sprite", "defineSprite.");
        this.registerDefinitionType(10, "videos", "video", "defineVideoStream.");
    }

    public String generate() {
        StringBuilder buffer = new StringBuilder(2048);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<report>\n");
        buffer.append("  <swf size=\"");
        buffer.append(this.size);
        buffer.append("\" compressedSize=\"");
        buffer.append(this.compressedSize);
        buffer.append("\">\n");
        this.dumpDefinitionType(buffer, 5, "    ");
        this.dumpDefinitionType(buffer, 3, "    ");
        this.dumpDefinitionType(buffer, 6, "    ");
        this.dumpDefinitionType(buffer, 2, "    ");
        this.dumpDefinitionType(buffer, 9, "    ");
        this.dumpDefinitionType(buffer, 7, "    ");
        this.dumpDefinitionType(buffer, 1, "    ");
        this.dumpDefinitionType(buffer, 8, "    ");
        this.dumpDefinitionType(buffer, 10, "    ");
        this.dumpDefinitionType(buffer, 0, "    ");
        this.dumpDefinitionType(buffer, 4, "    ");
        buffer.append("  </swf>\n");
        buffer.append("</report>");
        return buffer.toString();
    }

    public void setSize(int value) {
        this.size = value;
    }

    public void setCompressedSize(int value) {
        this.compressedSize = value;
    }

    private void dumpDefinitionType(StringBuilder buffer, int type, String indent) {
        DefinitionData data = this.definitionTypes.get(type);
        List<DefinitionEntry> definitions = data.definitions;
        Comparator<DefinitionEntry> comparator = type == 3 ? new FrameComparator() : new DefinitionComparator();
        Collections.sort(definitions, comparator);
        if (definitions.size() > 0) {
            buffer.append("\n" + indent + "<!-- " + data.description + " -->\n");
            buffer.append(indent + "<" + data.pluralMoniker + " ");
            buffer.append("totalSize=\"");
            buffer.append(data.totalSize);
            buffer.append("\">\n");
            for (DefinitionEntry n : definitions) {
                String name;
                buffer.append(indent + "  <" + data.singularMoniker + " ");
                String string = name = type == 3 || type == 6 ? n.stringData : this.symbols.get(n.id);
                if (name != null) {
                    buffer.append("name=\"");
                    buffer.append(name);
                    buffer.append("\" ");
                }
                if (type == 2 && n.stringData != null) {
                    buffer.append("fontName=\"");
                    buffer.append(n.stringData);
                    buffer.append("\" ");
                } else if ((type == 5 || type == 4) && n.stringData != null) {
                    buffer.append("type=\"");
                    buffer.append(n.stringData);
                    buffer.append("\" ");
                }
                buffer.append("size=\"");
                buffer.append(n.size);
                if (n.frame != -1 && type != 5) {
                    buffer.append("\" ");
                    buffer.append("frame=\"");
                    buffer.append(n.frame);
                }
                buffer.append("\"/>\n");
            }
            buffer.append(indent + "</" + data.pluralMoniker + ">\n");
        }
    }

    public void startEntry(int type, int startOffset, int id, String stringData) {
        if (type == 3) {
            this.prevFrameLabel = stringData;
        } else {
            DefinitionData data = this.definitionTypes.get(type);
            DefinitionEntry entry = new DefinitionEntry();
            entry.stringData = stringData;
            entry.size = startOffset;
            entry.id = id;
            entry.frame = this.currentFrame;
            data.definitions.add(entry);
        }
    }

    public void endEntry(int type, int endOffset, String stringData) {
        if (type == 3) {
            DefinitionData data = this.definitionTypes.get(type);
            DefinitionEntry entry = new DefinitionEntry();
            entry.size = this.currentFrameSize;
            entry.stringData = this.prevFrameLabel;
            entry.frame = this.currentFrame;
            data.definitions.add(entry);
            data.totalSize += entry.size.intValue();
            ++this.currentFrame;
            this.currentFrameSize = 0;
        } else {
            DefinitionData data = this.definitionTypes.get(type);
            DefinitionEntry entry = data.definitions.get(data.definitions.size() - 1);
            entry.size = endOffset - entry.size;
            data.totalSize += entry.size.intValue();
            this.currentFrameSize += entry.size.intValue();
        }
    }

    public void addEntry(int type, int id, int size, String stringData) {
        DefinitionData data = this.definitionTypes.get(type);
        DefinitionEntry entry = new DefinitionEntry();
        data.totalSize += size;
        entry.stringData = stringData;
        entry.size = size;
        entry.id = id;
        entry.frame = this.currentFrame;
        data.definitions.add(entry);
        this.currentFrameSize += entry.size.intValue();
    }

    public void startEntry(int type, int startOffset, int id) {
        this.startEntry(type, startOffset, id, null);
    }

    public void endEntry(int type, int endOffset) {
        this.endEntry(type, endOffset, null);
    }

    public void addEntry(int type, int id, int size) {
        this.addEntry(type, id, size, null);
    }

    public void addSymbol(String name, int id) {
        this.symbols.put(id, name);
    }

    private void registerDefinitionType(int type, String pluralMoniker, String singularMoniker, String description) {
        this.definitionTypes.put(type, new DefinitionData(pluralMoniker, singularMoniker, description));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FrameComparator
    implements Comparator<DefinitionEntry> {
        private FrameComparator() {
        }

        @Override
        public final int compare(DefinitionEntry a, DefinitionEntry b) {
            return a.frame.compareTo(b.frame);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefinitionComparator
    implements Comparator<DefinitionEntry> {
        private DefinitionComparator() {
        }

        @Override
        public final int compare(DefinitionEntry a, DefinitionEntry b) {
            return -a.size.compareTo(b.size);
        }
    }

    private class DefinitionData {
        public List<DefinitionEntry> definitions;
        public int totalSize;
        public String singularMoniker;
        public String pluralMoniker;
        public String description;

        public DefinitionData(String pluralMoniker, String singularMoniker, String description) {
            this.singularMoniker = singularMoniker;
            this.pluralMoniker = pluralMoniker;
            this.description = description;
            this.definitions = new ArrayList<DefinitionEntry>();
        }
    }

    private class DefinitionEntry {
        public Integer size;
        public Integer id;
        public String stringData;
        public Integer frame = -1;

        private DefinitionEntry() {
        }
    }
}

