/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.internal.as.codegen.InstructionListNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLBindingAttributeNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLBindingNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLDataBindingParser;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSingleDataBindingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLBuilder {
    private MXMLInstanceNode parent;
    private MXMLTreeBuilder builder;
    private IMXMLTagData rootTag;
    PrefixMap externalPrefixes;
    Set<String> referencedPrefixes = new HashSet<String>();
    private List<IMXMLBindingNode> databindings = new ArrayList<IMXMLBindingNode>();

    public XMLBuilder(MXMLInstanceNode parent, IMXMLTagData rootTag, PrefixMap externalPrefixes, MXMLTreeBuilder builder) {
        this.parent = parent;
        this.rootTag = rootTag;
        this.externalPrefixes = externalPrefixes;
        this.builder = builder;
    }

    void processNode(IMXMLTagData tag, StringWriter sw) {
        sw.write(60);
        if (tag.isCloseTag()) {
            sw.write(47);
        }
        sw.write(tag.getName());
        String tagPrefix = tag.getPrefix();
        if (tagPrefix != null) {
            this.lookupPrefix(tagPrefix, tag);
        }
        List<IMXMLTagAttributeData> attrs = this.getAttributes(tag);
        for (IMXMLTagAttributeData attr : attrs) {
            sw.write(32);
            sw.write(attr.getName());
            sw.write(61);
            sw.write(34);
            sw.write(attr.getRawValue());
            sw.write(34);
            String prefix = attr.getPrefix();
            if (prefix == null) continue;
            this.lookupPrefix(prefix, tag);
        }
        StringWriter childrenSW = new StringWriter();
        for (Object unit = tag.getFirstChildUnit(); unit != null; unit = unit.getNextSiblingUnit()) {
            this.processNode((IMXMLUnitData)unit, childrenSW);
        }
        if (tag == this.rootTag) {
            for (String prefix : this.referencedPrefixes) {
                String uri = this.externalPrefixes.getNamespaceForPrefix(prefix);
                if (uri == null) continue;
                sw.write(" xmlns");
                if (!prefix.isEmpty()) {
                    sw.write(":");
                }
                sw.write(prefix);
                sw.write("=\"");
                sw.write(uri);
                sw.write(34);
            }
        }
        if (tag.isEmptyTag()) {
            sw.write("/>");
        } else {
            sw.write(62);
        }
        sw.write(childrenSW.toString());
        IMXMLTagData endTag = tag.findMatchingEndTag();
        if (endTag != null) {
            this.processNode(endTag, sw);
        }
    }

    void lookupPrefix(String prefix, IMXMLTagData tag) {
        while (tag != null) {
            PrefixMap pm = tag.getPrefixMap();
            if (pm != null && pm.containsPrefix(prefix)) {
                return;
            }
            if (tag == this.rootTag) {
                tag = null;
                continue;
            }
            tag = tag.getParentTag();
        }
        if (this.externalPrefixes.containsPrefix(prefix)) {
            this.referencedPrefixes.add(prefix);
        }
    }

    void processNode(IMXMLTextData tag, StringWriter sw) {
        switch (tag.getTextType()) {
            case CDATA: {
                sw.write(tag.getContent());
                break;
            }
            case TEXT: {
                IMXMLSingleDataBindingNode db = null;
                db = this.parseBindingExpression(tag);
                if (db != null) {
                    this.databindings.add(this.generateBindingNode(tag, db));
                    if (this.isOnlyTextChild(tag)) break;
                    sw.write("<![CDATA[]]>");
                    break;
                }
                sw.write(XMLBuilder.replaceBindingEscapes(tag.getContent()));
            }
        }
    }

    private MXMLBindingNode generateBindingNode(IMXMLTextData tag, IMXMLSingleDataBindingNode dbnode) {
        return this.generateBindingNode(tag, null, dbnode);
    }

    private MXMLBindingNode generateBindingNode(IMXMLTagAttributeData attr, IMXMLSingleDataBindingNode dbnode) {
        return this.generateBindingNode(attr.getParent(), attr, dbnode);
    }

    private MXMLBindingNode generateBindingNode(IMXMLUnitData tag, IMXMLTagAttributeData attr, IMXMLSingleDataBindingNode dbnode) {
        InstructionListNode destExpr = this.getTargetExprNode(tag, attr);
        MXMLBindingNode bindingNode = new MXMLBindingNode(this.parent);
        MXMLBindingAttributeNode target = new MXMLBindingAttributeNode(bindingNode, destExpr);
        target.setLocation(attr);
        target.setName(attr.getName());
        destExpr.setParent(target);
        MXMLBindingAttributeNode source = new MXMLBindingAttributeNode(bindingNode, dbnode.getExpressionNode());
        bindingNode.setDestinationAttributeNode(target);
        bindingNode.setSourceAttributeNode(source);
        return bindingNode;
    }

    private IMXMLSingleDataBindingNode parseBindingExpression(IMXMLTextData text) {
        Object o = MXMLDataBindingParser.parse(this.parent, text, text.getFragments(this.builder.getProblems()), this.builder.getProblems(), this.builder.getWorkspace(), this.builder.getMXMLDialect(), this.builder.getProject());
        if (o instanceof IMXMLSingleDataBindingNode) {
            return (IMXMLSingleDataBindingNode)o;
        }
        return null;
    }

    private IMXMLSingleDataBindingNode parseBindingExpression(IMXMLTagAttributeData attr) {
        Object o = MXMLDataBindingParser.parse(this.parent, attr, attr.getValueFragments(this.builder.getProblems()), this.builder.getProblems(), this.builder.getWorkspace(), this.builder.getMXMLDialect(), this.builder.getProject());
        if (o instanceof IMXMLSingleDataBindingNode) {
            return (IMXMLSingleDataBindingNode)o;
        }
        return null;
    }

    private InstructionListNode getTargetExprNode(IMXMLUnitData data, IMXMLTagAttributeData attr) {
        InstructionListNode expr = null;
        InstructionList il = this.getTargetInstructions(data, attr);
        if (il != null) {
            expr = new InstructionListNode(il);
        }
        return expr;
    }

    private InstructionList getTargetInstructions(IMXMLUnitData data, IMXMLTagAttributeData attr) {
        IMXMLUnitData d = data;
        Stack<IMXMLUnitData> parentStack = new Stack<IMXMLUnitData>();
        if (this.isOnlyTextChild(d)) {
            d = d.getParentUnitData();
        }
        IMXMLUnitData target = d;
        while (d != null) {
            parentStack.add(d);
            d = d == this.rootTag ? null : d.getParentUnitData();
        }
        InstructionList il = new InstructionList();
        il.addInstruction(208);
        while (parentStack.size() > 1) {
            IMXMLUnitData unitData = (IMXMLUnitData)parentStack.pop();
            if (!(unitData instanceof IMXMLTagData)) continue;
            this.generateGetInstructions(il, (IMXMLTagData)unitData);
        }
        if (target instanceof IMXMLTagData) {
            if (attr == null) {
                this.generateSetInstructions(il, (IMXMLTagData)target);
            } else {
                this.generateGetInstructions(il, (IMXMLTagData)target);
                this.generateSetInstructions(il, attr);
            }
        } else if (target instanceof IMXMLTextData) {
            this.generateSetInstructions(il, (IMXMLTextData)target);
        }
        return il;
    }

    private void generateGetInstructions(InstructionList il, IMXMLTagData tag) {
        if (tag == this.rootTag) {
            il.addInstruction(102, this.getNameForTag(tag));
        } else {
            il.addInstruction(102, this.getNameForTag(tag));
            int index = this.getIndexOfTag(tag);
            il.addInstruction(102, new Name(String.valueOf(index)));
        }
    }

    private void generateSetInstructions(InstructionList il, IMXMLTagData tag) {
        if (tag == this.rootTag) {
            il.addInstruction(209);
            il.addInstruction(97, this.getNameForTag(tag));
        } else {
            il.addInstruction(102, this.getNameForTag(tag));
            il.addInstruction(209);
            int index = this.getIndexOfTag(tag);
            il.addInstruction(97, new Name(String.valueOf(index)));
        }
    }

    private void generateSetInstructions(InstructionList il, IMXMLTagAttributeData attr) {
        il.addInstruction(209);
        il.addInstruction(97, this.getNameForAttr(attr));
    }

    private void generateSetInstructions(InstructionList il, IMXMLTextData text) {
        il.addInstruction(70, new Object[]{new Name("text"), 0});
        il.addInstruction(209);
        int index = this.getIndexOfText(text);
        il.addInstruction(97, new Name(String.valueOf(index)));
    }

    private int getIndexOfTag(IMXMLTagData tag) {
        IMXMLTagData parent = tag.getParentTag();
        int index = 0;
        for (IMXMLTagData d = parent.getFirstChild(true); d != null && d != tag; d = d.getNextSibling(true)) {
            if (!d.getName().equals(tag.getName())) continue;
            ++index;
        }
        return index;
    }

    private int getIndexOfText(IMXMLTextData text) {
        IMXMLUnitData parent = text.getParentUnitData();
        IMXMLTagData parentTag = parent instanceof IMXMLTagData ? (IMXMLTagData)parent : null;
        int index = 0;
        if (parentTag != null) {
            for (IMXMLUnitData d = parentTag.getFirstChildUnit(); d != null && d != text; d = d.getNextSiblingUnit()) {
                if (!(d instanceof IMXMLTextData) || ((IMXMLTextData)d).getTextType() != IMXMLTextData.TextType.CDATA) continue;
                ++index;
            }
        }
        return index;
    }

    private boolean isOnlyTextChild(IMXMLUnitData child) {
        if (child instanceof IMXMLTextData && ((IMXMLTextData)child).getTextType() == IMXMLTextData.TextType.TEXT) {
            IMXMLTagData parent;
            IMXMLUnitData p = child.getParentUnitData();
            IMXMLTagData iMXMLTagData = parent = p instanceof IMXMLTagData ? (IMXMLTagData)p : null;
            if (parent != null) {
                return parent.getFirstChildUnit() == child && child.getNextSiblingUnit() == null;
            }
        }
        return false;
    }

    private Name getNameForTag(IMXMLTagData tag) {
        if (tag == this.rootTag) {
            return new Name(this.parent.getEffectiveID());
        }
        String uri = tag.getURI();
        if (uri != null) {
            return new Name(new Namespace(8, uri), tag.getShortName());
        }
        return new Name(tag.getShortName());
    }

    private Name getNameForAttr(IMXMLTagAttributeData attr) {
        String uri = attr.getURI();
        if (uri != null) {
            return new Name(13, new Nsset(new Namespace(8, uri)), attr.getShortName());
        }
        return new Name(13, new Nsset(new Namespace(8, "")), attr.getShortName());
    }

    public static String replaceBindingEscapes(String toClean) {
        toClean = XMLBuilder.cleanupEscapedCharForXML('{', toClean);
        toClean = XMLBuilder.cleanupEscapedCharForXML('}', toClean);
        toClean = XMLBuilder.cleanupEscapedCharForXML('@', toClean);
        return toClean;
    }

    private static String cleanupEscapedCharForXML(char escapedChar, String toClean) {
        int i;
        if (toClean == null || toClean.indexOf(escapedChar) == -1 || toClean.indexOf(92) == -1) {
            return toClean;
        }
        StringBuilder buf = new StringBuilder(toClean.length());
        char[] chars = toClean.toCharArray();
        for (i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != '\\' || chars[i + 1] != escapedChar) {
                buf.append(chars[i]);
                continue;
            }
            buf.append("&#x" + Integer.toString(chars[i + 1], 16) + ";");
            ++i;
        }
        if (i == chars.length - 1) {
            buf.append(chars[chars.length - 1]);
        }
        return buf.toString();
    }

    List<IMXMLTagAttributeData> getAttributes(IMXMLTagData tag) {
        IMXMLTagAttributeData[] rawAttrs = tag.getAttributeDatas();
        if (rawAttrs != null) {
            ArrayList<IMXMLTagAttributeData> attrs = new ArrayList<IMXMLTagAttributeData>(rawAttrs.length);
            for (IMXMLTagAttributeData attr : rawAttrs) {
                IMXMLSingleDataBindingNode db = null;
                db = this.parseBindingExpression(attr);
                if (db != null) {
                    this.databindings.add(this.generateBindingNode(attr, db));
                    continue;
                }
                attrs.add(attr);
            }
            return attrs;
        }
        return Collections.emptyList();
    }

    void processNode(IMXMLUnitData node, StringWriter sw) {
        if (node instanceof IMXMLTagData) {
            this.processNode((IMXMLTagData)node, sw);
        } else if (node instanceof IMXMLTextData) {
            this.processNode((IMXMLTextData)node, sw);
        }
    }

    public List<IMXMLBindingNode> getDatabindings() {
        return this.databindings;
    }
}

