/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLModelPropertyNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyContainerNode;
import org.apache.royale.compiler.tree.mxml.IMXMLModelPropertyNode;

abstract class MXMLModelPropertyContainerNodeBase
extends MXMLNodeBase
implements IMXMLModelPropertyContainerNode {
    private static final IMXMLModelPropertyNode[] NO_PROPERTY_NODES = new IMXMLModelPropertyNode[0];
    private String name;
    private IMXMLModelPropertyNode[] propertyNodes = NO_PROPERTY_NODES;
    private List<String> propertyNameList;
    private ListMultimap<String, IMXMLModelPropertyNode> propertyMultimap;
    private int index = -1;

    MXMLModelPropertyContainerNodeBase(NodeBase parent) {
        super(parent);
    }

    public String getName() {
        return this.name;
    }

    public int getChildCount() {
        return this.propertyNodes.length;
    }

    public IASNode getChild(int i) {
        return this.propertyNodes[i];
    }

    public IMXMLModelPropertyNode[] getPropertyNodes() {
        return this.propertyNodes;
    }

    public String[] getPropertyNames() {
        return this.propertyNameList != null ? this.propertyNameList.toArray(new String[0]) : new String[]{};
    }

    public IMXMLModelPropertyNode[] getPropertyNodes(String propertyName) {
        return this.propertyMultimap != null ? this.propertyMultimap.get((Object)propertyName).toArray(new IMXMLModelPropertyNode[0]) : new IMXMLModelPropertyNode[]{};
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    protected void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        this.name = attribute.getShortName();
        this.setLocation(attribute);
    }

    protected void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        this.name = tag.getShortName();
        super.initializeFromTag(builder, tag);
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.getPrefix() != null) {
            // empty if block
        }
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromAttribute(builder, attribute);
        info.addChildNode(propertyNode);
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getPrefix() != null) {
            // empty if block
        }
        MXMLModelPropertyNode propertyNode = new MXMLModelPropertyNode(this);
        propertyNode.initializeFromTag(builder, childTag);
        info.addChildNode(propertyNode);
    }

    void setPropertyNodes(IMXMLModelPropertyNode[] propertyNodes) {
        this.propertyNodes = propertyNodes;
        for (IMXMLModelPropertyNode propertyNode : propertyNodes) {
            int n;
            String propertyName = propertyNode.getName();
            if (this.propertyMultimap == null) {
                this.propertyMultimap = ArrayListMultimap.create();
            }
            if (this.propertyNameList == null) {
                this.propertyNameList = new ArrayList<String>();
            }
            if ((n = this.propertyMultimap.get((Object)propertyName).size()) == 0) {
                this.propertyNameList.add(propertyName);
            }
            this.propertyMultimap.put((Object)propertyName, (Object)propertyNode);
        }
        if (this.propertyNameList != null) {
            for (String propertyName : this.propertyNameList) {
                List list = this.propertyMultimap.get((Object)propertyName);
                if (list.size() <= 1) continue;
                int i = 0;
                for (IMXMLModelPropertyNode node : list) {
                    ((MXMLModelPropertyNode)node).setIndex(i++);
                }
            }
        }
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        int index = this.getIndex();
        if (index != -1) {
            sb.append(' ');
            sb.append('[');
            sb.append(index);
            sb.append(']');
        }
        return true;
    }
}

