/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.definitions.IAccessorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IEffectDefinition;
import org.apache.royale.compiler.definitions.IEventDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.IStyleDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLTagData;
import org.apache.royale.compiler.internal.mxml.MXMLTextData;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragment;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLEffectSpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLEventSpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLPropertySpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLReparentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLScriptNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLStyleSpecifierNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.MXMLDuplicateChildTagProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLClassReferenceNode;
import org.apache.royale.compiler.tree.mxml.IMXMLEventSpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import org.apache.royale.compiler.tree.mxml.IMXMLSpecifierNode;

abstract class MXMLClassReferenceNodeBase
extends MXMLNodeBase
implements IMXMLClassReferenceNode {
    private IClassDefinition classReference;
    private boolean isMXMLObject = false;
    private boolean isContainer = false;
    private boolean isVisualElementContainer = false;
    private boolean isDeferredInstantiationUIComponent = false;
    private IMXMLNode[] children;
    private Map<String, IMXMLPropertySpecifierNode> propertyNodeMap;
    private List<IMXMLPropertySpecifierNode> allPropertyNodes;
    private Map<String, IMXMLEventSpecifierNode> eventNodeMap;
    private List<IMXMLEventSpecifierNode> allEventNodes;
    private Map<String, Collection<IMXMLSpecifierNode>> suffixSpecifierMap;
    private IVariableDefinition defaultPropertyDefinition;
    private IVariableDefinition altDefaultPropertyDefinition;
    private boolean defaultPropertyDefinitionInitialized = false;
    private boolean processingDefaultProperty = false;
    private boolean processedDefaultProperty = false;
    private MXMLPropertySpecifierNode defaultPropertyNode;
    private List<IMXMLUnitData> defaultPropertyContentUnits;

    MXMLClassReferenceNodeBase(NodeBase parent) {
        super(parent);
    }

    public IASNode getChild(int i) {
        return this.children != null ? this.children[i] : null;
    }

    public int getChildCount() {
        return this.children != null ? this.children.length : 0;
    }

    public String getName() {
        return this.classReference != null ? this.classReference.getQualifiedName() : "";
    }

    public IClassDefinition getClassReference(ICompilerProject project) {
        return this.classReference;
    }

    public boolean isMXMLObject() {
        return this.isMXMLObject;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public boolean isVisualElementContainer() {
        return this.isVisualElementContainer;
    }

    public boolean isDeferredInstantiationUIComponent() {
        return this.isDeferredInstantiationUIComponent;
    }

    void setClassReference(RoyaleProject project, IClassDefinition classReference) {
        this.classReference = classReference;
        String mxmlObjectInterface = project.getMXMLObjectInterface();
        this.isMXMLObject = classReference.isInstanceOf(mxmlObjectInterface, (ICompilerProject)project);
        String visualElementContainerInterface = project.getVisualElementContainerInterface();
        this.isVisualElementContainer = classReference.isInstanceOf(visualElementContainerInterface, (ICompilerProject)project);
        String containerInterface = project.getContainerInterface();
        this.isContainer = classReference.isInstanceOf(containerInterface, (ICompilerProject)project);
        String deferredInstantiationUIComponentInterface = project.getDeferredInstantiationUIComponentInterface();
        this.isDeferredInstantiationUIComponent = classReference.isInstanceOf(deferredInstantiationUIComponentInterface, (ICompilerProject)project);
    }

    void setClassReference(RoyaleProject project, String qname) {
        ASProjectScope projectScope = project.getScope();
        IDefinition definition = projectScope.findDefinitionByName(qname);
        if (definition instanceof IClassDefinition) {
            this.setClassReference(project, (IClassDefinition)definition);
        }
    }

    void setChildren(IMXMLNode[] children) {
        this.children = children;
        if (children != null) {
            for (IMXMLNode child : children) {
                if (child instanceof IMXMLPropertySpecifierNode) {
                    if (this.propertyNodeMap == null) {
                        this.propertyNodeMap = new HashMap<String, IMXMLPropertySpecifierNode>();
                        this.allPropertyNodes = new ArrayList<IMXMLPropertySpecifierNode>();
                    }
                    this.propertyNodeMap.put(child.getName(), (IMXMLPropertySpecifierNode)child);
                    this.allPropertyNodes.add((IMXMLPropertySpecifierNode)child);
                } else if (child instanceof IMXMLEventSpecifierNode) {
                    if (this.eventNodeMap == null) {
                        this.eventNodeMap = new HashMap<String, IMXMLEventSpecifierNode>();
                        this.allEventNodes = new ArrayList<IMXMLEventSpecifierNode>();
                    }
                    this.eventNodeMap.put(child.getName(), (IMXMLEventSpecifierNode)child);
                    this.allEventNodes.add((IMXMLEventSpecifierNode)child);
                }
                if (!(child instanceof IMXMLSpecifierNode) || this.suffixSpecifierMap != null) continue;
                this.suffixSpecifierMap = new HashMap<String, Collection<IMXMLSpecifierNode>>();
            }
        }
    }

    public IMXMLPropertySpecifierNode getPropertySpecifierNode(String name) {
        return this.propertyNodeMap != null ? this.propertyNodeMap.get(name) : null;
    }

    public IMXMLPropertySpecifierNode[] getPropertySpecifierNodes() {
        return this.allPropertyNodes != null ? this.allPropertyNodes.toArray(new IMXMLPropertySpecifierNode[0]) : null;
    }

    public IMXMLEventSpecifierNode getEventSpecifierNode(String name) {
        return this.eventNodeMap != null ? this.eventNodeMap.get(name) : null;
    }

    public IMXMLEventSpecifierNode[] getEventSpecifierNodes() {
        return this.allEventNodes != null ? this.allEventNodes.toArray(new IMXMLEventSpecifierNode[0]) : null;
    }

    public IMXMLSpecifierNode[] getSpecifierNodesWithSuffix(String suffix) {
        return this.suffixSpecifierMap != null ? this.suffixSpecifierMap.get(suffix).toArray(new IMXMLSpecifierNode[0]) : null;
    }

    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, attribute.getName());
        if (childNode != null) {
            childNode.setLocation(attribute);
            childNode.setSuffix(builder, attribute.getStateName());
            childNode.initializeFromAttribute(builder, attribute, info);
            info.addChildNode(childNode);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (info.hasSpecifierWithName(childTag.getShortName(), childTag.getStateName())) {
            MXMLDuplicateChildTagProblem problem = new MXMLDuplicateChildTagProblem(childTag);
            builder.addProblem(problem);
            return;
        }
        RoyaleProject project = builder.getProject();
        MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, childTag.getShortName());
        if (childNode != null) {
            this.processNonDefaultPropertyContentUnit(builder, info, tag);
            childNode.setSuffix(builder, childTag.getStateName());
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        } else if (builder.getFileScope().isScriptTag(childTag) && builder.getMXMLDialect().isEqualToOrBefore(MXMLDialect.MXML_2009)) {
            if (!this.processingDefaultProperty) {
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, childTag);
                info.addChildNode(scriptNode);
            } else {
                this.processDefaultPropertyContentUnit(builder, childTag, info);
            }
        } else if (builder.getFileScope().isReparentTag(childTag)) {
            MXMLReparentNode reparentNode = new MXMLReparentNode(this);
            reparentNode.initializeFromTag(builder, childTag);
            info.addChildNode(reparentNode);
        } else {
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
            if (definition instanceof ClassDefinition) {
                IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
                if (defaultPropertyDefinition != null) {
                    if (this.processedDefaultProperty) {
                        MXMLDuplicateChildTagProblem problem = new MXMLDuplicateChildTagProblem(childTag);
                        problem.childTag = defaultPropertyDefinition.getBaseName();
                        problem.element = tag.getShortName();
                        builder.addProblem(problem);
                        return;
                    }
                    this.processDefaultPropertyContentUnit(builder, childTag, info);
                } else {
                    this.processNonDefaultPropertyContentUnit(builder, info, tag);
                    MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                    instanceNode.setClassReference(project, (IClassDefinition)definition);
                    instanceNode.initializeFromTag(builder, childTag);
                    info.addChildNode(instanceNode);
                }
            } else {
                IVariableDefinition textDef;
                String uri;
                IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
                if (defaultPropertyDefinition != null && !this.processedDefaultProperty && defaultPropertyDefinition.getBaseName().equals("text")) {
                    IVariableDefinition htmlDef;
                    String uri2 = childTag.getURI();
                    if (uri2.equals("http://www.w3.org/1999/xhtml") && (htmlDef = (IVariableDefinition)project.resolveSpecifier(this.classReference, "html")) != null) {
                        defaultPropertyDefinition = this.defaultPropertyDefinition = htmlDef;
                        this.processDefaultPropertyContentUnit(builder, childTag, info);
                        this.processNonDefaultPropertyContentUnit(builder, info, tag);
                        return;
                    }
                } else if (this.altDefaultPropertyDefinition != null && !this.processedDefaultProperty && this.altDefaultPropertyDefinition.getBaseName().equals("innerHTML") && (uri = childTag.getURI()).equals("library://ns.apache.org/royale/html") && (textDef = (IVariableDefinition)project.resolveSpecifier(this.classReference, "innerHTML")) != null) {
                    List<IMXMLNode> nodes = info.getChildNodeList();
                    if (nodes.size() > 0) {
                        MXMLPropertySpecifierNode propNode;
                        String name;
                        IMXMLNode lastNode = nodes.get(nodes.size() - 1);
                        if (lastNode.getNodeID() == ASTNodeID.MXMLPropertySpecifierID && (name = (propNode = (MXMLPropertySpecifierNode)lastNode).getName()).equals("innerHTML")) {
                            SourceFragment sourceFragment;
                            ISourceFragment[] sourceFragments = new SourceFragment[1];
                            String tagAsString = ((MXMLTagData)childTag).stringify();
                            sourceFragments[0] = sourceFragment = new SourceFragment(tagAsString, tagAsString, childTag.getLocationOfChildUnits());
                            info.addSourceFragments(childTag.getSourcePath(), sourceFragments);
                        }
                    } else {
                        childNode = this.createSpecifierNode(builder, "innerHTML");
                        if (childNode != null) {
                            childNode.setSuffix(builder, childTag.getStateName());
                            String tagAsString = ((MXMLTagData)childTag).stringify();
                            String tagAsCData = "<![CDATA[" + tagAsString + "]]>";
                            MXMLToken token = new MXMLToken(2, childTag.getStart(), childTag.getEnd(), childTag.getLine(), childTag.getColumn(), tagAsCData);
                            MXMLTextData text = new MXMLTextData(token);
                            text.setSourceLocation(childTag.getLocationOfChildUnits());
                            childNode.initializeFromText(builder, text, info);
                            info.addChildNode(childNode);
                        }
                    }
                    return;
                }
                if (this.processingDefaultProperty && definition == null) {
                    builder.getProblems().add(new MXMLUnresolvedTagProblem(childTag));
                    return;
                }
                this.processNonDefaultPropertyContentUnit(builder, info, tag);
                super.processChildTag(builder, tag, childTag, info);
            }
        }
    }

    private IVariableDefinition getDefaultPropertyDefinition(MXMLTreeBuilder builder) {
        if (!this.defaultPropertyDefinitionInitialized) {
            RoyaleProject project = builder.getProject();
            String defaultPropertyName = this.classReference.getDefaultPropertyName(project);
            if (defaultPropertyName != null) {
                if (defaultPropertyName.contains("|")) {
                    int c = defaultPropertyName.indexOf("|");
                    String alt = defaultPropertyName.substring(c + 1);
                    defaultPropertyName = defaultPropertyName.substring(0, c);
                    this.altDefaultPropertyDefinition = (IVariableDefinition)project.resolveSpecifier(this.classReference, alt);
                }
                this.defaultPropertyDefinition = (IVariableDefinition)project.resolveSpecifier(this.classReference, defaultPropertyName);
            }
            this.defaultPropertyDefinitionInitialized = true;
        }
        return this.defaultPropertyDefinition;
    }

    private void processDefaultPropertyContentUnit(MXMLTreeBuilder builder, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (!this.processingDefaultProperty) {
            this.processingDefaultProperty = true;
            String defaultPropertyName = this.getDefaultPropertyDefinition(builder).getBaseName();
            this.defaultPropertyNode = (MXMLPropertySpecifierNode)this.createSpecifierNode(builder, defaultPropertyName);
            info.addChildNode(this.defaultPropertyNode);
            this.defaultPropertyContentUnits = new ArrayList<IMXMLUnitData>(1);
        }
        this.defaultPropertyContentUnits.add(childTag);
    }

    private void processNonDefaultPropertyContentUnit(MXMLTreeBuilder builder, MXMLNodeBase.MXMLNodeInfo info, IMXMLTagData parentTag) {
        if (this.processingDefaultProperty) {
            int lastNonScriptTagIndex;
            this.processingDefaultProperty = false;
            this.processedDefaultProperty = true;
            assert (this.defaultPropertyContentUnits.size() > 0);
            assert (!builder.getFileScope().isScriptTag(this.defaultPropertyContentUnits.get(0))) : "First default property content unit must not be a script tag!";
            for (lastNonScriptTagIndex = this.defaultPropertyContentUnits.size() - 1; lastNonScriptTagIndex > 0; --lastNonScriptTagIndex) {
                IMXMLUnitData unitData = this.defaultPropertyContentUnits.get(lastNonScriptTagIndex);
                if (!builder.getFileScope().isScriptTag(unitData)) break;
            }
            assert (lastNonScriptTagIndex >= 0);
            assert (lastNonScriptTagIndex < this.defaultPropertyContentUnits.size());
            List<IMXMLUnitData> trailingScriptTags = this.defaultPropertyContentUnits.subList(lastNonScriptTagIndex + 1, this.defaultPropertyContentUnits.size());
            List<IMXMLUnitData> defaultPropertyContentUnitsWithoutTrailingScriptTags = this.defaultPropertyContentUnits.subList(0, lastNonScriptTagIndex + 1);
            IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
            this.defaultPropertyNode.initializeDefaultProperty(builder, defaultPropertyDefinition, parentTag, defaultPropertyContentUnitsWithoutTrailingScriptTags);
            for (IMXMLUnitData scriptTagData : trailingScriptTags) {
                assert (builder.getFileScope().isScriptTag(scriptTagData));
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, (IMXMLTagData)scriptTagData);
                info.addChildNode(scriptNode);
            }
        }
    }

    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        IAccessorDefinition getterDefinition;
        IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
        IAccessorDefinition iAccessorDefinition = getterDefinition = defaultPropertyDefinition instanceof ISetterDefinition ? ((ISetterDefinition)defaultPropertyDefinition).resolveCorrespondingAccessor(builder.getProject()) : null;
        if (defaultPropertyDefinition != null && (defaultPropertyDefinition.getTypeAsDisplayString().equals("String") || defaultPropertyDefinition.getMetaTagByName("RichTextContent") != null || getterDefinition != null && getterDefinition.getMetaTagByName("RichTextContent") != null)) {
            MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, defaultPropertyDefinition.getBaseName());
            if (childNode != null) {
                childNode.initializeFromText(builder, text, info);
                info.addChildNode(childNode);
            }
        } else if (this.altDefaultPropertyDefinition != null && this.altDefaultPropertyDefinition.getTypeAsDisplayString().equals("String")) {
            MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, this.altDefaultPropertyDefinition.getBaseName());
            if (childNode != null) {
                childNode.initializeFromText(builder, text, info);
                info.addChildNode(childNode);
            }
        } else {
            super.processChildNonWhitespaceUnit(builder, tag, text, info);
        }
    }

    protected MXMLSpecifierNodeBase createSpecifierNode(MXMLTreeBuilder builder, String specifierName) {
        MXMLSpecifierNodeBase specifierNode = null;
        RoyaleProject project = builder.getProject();
        IDefinition specifierDefinition = project.resolveSpecifier(this.classReference, specifierName);
        if (specifierDefinition instanceof ISetterDefinition || specifierDefinition instanceof IVariableDefinition) {
            specifierNode = new MXMLPropertySpecifierNode(this);
        } else if (specifierDefinition instanceof IEventDefinition) {
            specifierNode = new MXMLEventSpecifierNode(this);
        } else if (specifierDefinition instanceof IStyleDefinition) {
            specifierNode = new MXMLStyleSpecifierNode(this);
        } else if (specifierDefinition instanceof IEffectDefinition) {
            specifierNode = new MXMLEffectSpecifierNode(this);
        }
        if (specifierNode != null) {
            specifierNode.setDefinition(specifierDefinition);
        } else if (this.classReference.isDynamic()) {
            specifierNode = new MXMLPropertySpecifierNode(this);
            ((MXMLPropertySpecifierNode)specifierNode).setDynamicName(specifierName);
        }
        return specifierNode;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        this.processNonDefaultPropertyContentUnit(builder, info, tag);
        this.setChildren(info.getChildNodeList().toArray(new IMXMLNode[0]));
        if (this.isContainer) {
            RoyaleProject project = builder.getProject();
            builder.addExpressionDependency(project.getUIComponentDescriptorClass());
        }
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }
}

