/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.definitions.metadata.MetaTag;
import org.apache.royale.compiler.internal.scopes.ASScope;
import org.apache.royale.compiler.internal.semantics.PostProcessStep;
import org.apache.royale.compiler.internal.tree.as.BaseDefinitionNode;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.ContainerNode;
import org.apache.royale.compiler.internal.tree.as.MemberedNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.tree.as.metadata.MetaTagNode;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTagsNode
extends ContainerNode
implements IMetaTagsNode {
    private IDefinitionNode decoratedNode;

    public MetaTagsNode() {
        this.setContainerType(IContainerNode.ContainerType.BRACKETS);
    }

    public void setDecorationTarget(IDefinitionNode node) {
        this.decoratedNode = node;
    }

    public IDefinitionNode getDecoratedDefinition() {
        if (this.decoratedNode == null) {
            IASNode parent = this.getParent();
            if (parent instanceof BlockNode) {
                IASNode node = parent.getParent();
                if (node instanceof MemberedNode) {
                    IASNode child;
                    int i;
                    ScopedBlockNode contents = ((MemberedNode)node).getScopedNode();
                    int childCount = contents.getChildCount();
                    boolean found = false;
                    for (i = 0; i < childCount; ++i) {
                        child = contents.getChild(i);
                        if (found) {
                            if (!(child instanceof IDefinitionNode)) continue;
                            this.decoratedNode = (IDefinitionNode)child;
                            if (child instanceof ClassNode) {
                                this.analyze(EnumSet.of(PostProcessStep.POPULATE_SCOPE), ((ClassNode)child).getScopedNode().getASScope(), new ArrayList<ICompilerProblem>(0));
                            }
                            if (!(child instanceof BaseDefinitionNode)) break;
                            ((BaseDefinitionNode)child).setMetaTags(this);
                            break;
                        }
                        if (child != this) continue;
                        found = true;
                    }
                    if (this.decoratedNode == null && found) {
                        for (i = childCount - 1; i >= 0; --i) {
                            child = contents.getChild(i);
                            if (!(child instanceof IDefinitionNode)) continue;
                            this.decoratedNode = (IDefinitionNode)child;
                            if (child instanceof ClassNode) {
                                this.analyze(EnumSet.of(PostProcessStep.POPULATE_SCOPE), ((ClassNode)child).getScopedNode().getASScope(), new ArrayList<ICompilerProblem>(0));
                            }
                            if (child instanceof BaseDefinitionNode) {
                                ((BaseDefinitionNode)child).setMetaTags(this);
                            }
                            break;
                        }
                    }
                }
            } else if (parent instanceof IDefinitionNode) {
                this.decoratedNode = (IDefinitionNode)parent;
            }
        }
        return this.decoratedNode;
    }

    @Override
    protected int getInitialChildCount() {
        return 0;
    }

    public void addTag(MetaTagNode node) {
        if (node != null) {
            this.addChild(node);
        }
    }

    @Override
    public void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (scope == null) {
            return;
        }
        IScopedNode scopeNode = scope.getScopeNode();
        if (scopeNode != null && scopeNode.getParent() != null && scopeNode.getParent().equals(this.getDecoratedDefinition())) {
            super.analyze(set, scope, problems);
        }
    }

    @Override
    public void addItem(NodeBase child) {
        if (child instanceof IMetaTagNode) {
            super.addChildInOrder(child, true);
        }
    }

    @Override
    public void addChild(NodeBase child) {
        if (child instanceof IMetaTagNode) {
            super.addChildInOrder(child, true);
        }
    }

    @Override
    protected void addChildInOrder(NodeBase newChild, boolean fillInOffsets) {
        if (newChild instanceof IMetaTagNode) {
            super.addChildInOrder(newChild, fillInOffsets);
        }
    }

    @Override
    protected boolean canContinueContainmentSearch(IASNode containingNode, IASNode currentNode, int childOffset, boolean offsetStillValid) {
        return offsetStillValid ? this.isTransparent() && containingNode instanceof BlockNode && containingNode == currentNode : this.isTransparent();
    }

    public void removeAttribute(MetaTagNode node) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.getChild(i) != node) continue;
            this.removeChild(node);
        }
    }

    public boolean isEmpty() {
        return this.getChildCount() <= 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetaTagsNode)) {
            return false;
        }
        MetaTagsNode other = (MetaTagsNode)obj;
        int attributesCount = this.getChildCount();
        int otherAttributesCount = other.getChildCount();
        if (other.getAbsoluteStart() != this.getAbsoluteStart()) {
            return false;
        }
        if (other.getAbsoluteEnd() != this.getAbsoluteEnd()) {
            return false;
        }
        if (attributesCount != otherAttributesCount) {
            return false;
        }
        if (attributesCount == 0) {
            return true;
        }
        for (int i = 0; i < attributesCount; ++i) {
            IASNode otherAttribute;
            IASNode attribute = this.getChild(i);
            if (attribute.equals(otherAttribute = other.getChild(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IMetaTagNode[] getAllTags() {
        int childCount = this.getChildCount();
        IMetaTagNode[] tags = new IMetaTagNode[childCount];
        for (int i = 0; i < childCount; ++i) {
            tags[i] = (IMetaTagNode)this.getChild(i);
        }
        return tags;
    }

    @Override
    public IMetaTagNode[] getTagsByName(String name) {
        int size = this.getChildCount();
        ArrayList<IMetaTagNode> list = new ArrayList<IMetaTagNode>(size);
        for (int i = 0; i < size; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof IMetaTagNode) || ((IMetaTagNode)child).getTagName().compareTo(name) != 0) continue;
            list.add((IMetaTagNode)child);
        }
        return list.toArray(new IMetaTagNode[0]);
    }

    @Override
    public boolean hasTagByName(String name) {
        IMetaTagNode[] byName = this.getTagsByName(name);
        return byName != null && byName.length > 0;
    }

    @Override
    public IMetaTagNode getTagByName(String name) {
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            if (((IMetaTagNode)this.getChild(i)).getTagName().compareTo(name) != 0) continue;
            return (IMetaTagNode)this.getChild(i);
        }
        return null;
    }

    public IMetaTag[] buildMetaTags(IFileSpecification containingFileSpec, IDefinition definition) {
        assert (containingFileSpec != null);
        assert (definition != null);
        IMetaTagNode[] metaTagNodes = this.getAllTags();
        int n = metaTagNodes.length;
        IMetaTag[] metaTags = new MetaTag[n];
        for (int i = 0; i < n; ++i) {
            metaTags[i] = ((MetaTagNode)metaTagNodes[i]).buildMetaTag(containingFileSpec, definition);
        }
        return metaTags;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MetaTagsID;
    }
}

