/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.OperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorAtNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorBitwiseNotNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorDeleteNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorLogicalNotNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorMinusNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorPlusNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorPostDecrementNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorPostIncrementNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorPreDecrementNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorPreIncrementNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorTypeOfNode;
import org.apache.royale.compiler.internal.tree.as.UnaryOperatorVoidNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;

public abstract class UnaryOperatorNodeBase
extends OperatorNodeBase
implements IUnaryOperatorNode {
    private ExpressionNodeBase operandNode;

    public static UnaryOperatorNodeBase createPrefix(IASToken operatorToken, ExpressionNodeBase operand) {
        switch (operatorToken.getType()) {
            case 108: {
                return new UnaryOperatorPlusNode(operatorToken, operand);
            }
            case 107: {
                return new UnaryOperatorMinusNode(operatorToken, operand);
            }
            case 113: {
                return new UnaryOperatorPreIncrementNode(operatorToken, operand);
            }
            case 114: {
                return new UnaryOperatorPreDecrementNode(operatorToken, operand);
            }
            case 118: {
                return new UnaryOperatorLogicalNotNode(operatorToken, operand);
            }
            case 117: {
                return new UnaryOperatorBitwiseNotNode(operatorToken, operand);
            }
            case 154: {
                return new UnaryOperatorAtNode(operatorToken, operand);
            }
            case 112: {
                return new UnaryOperatorDeleteNode(operatorToken, operand);
            }
            case 116: {
                return new UnaryOperatorTypeOfNode(operatorToken, operand);
            }
            case 115: {
                return new UnaryOperatorVoidNode(operatorToken, operand);
            }
        }
        assert (false) : "Token '" + operatorToken.getText() + "' unexpected in UnaryOperatorNodeBase.createPrefix()";
        return null;
    }

    public static UnaryOperatorNodeBase createPostfix(IASToken operatorToken, ExpressionNodeBase operand) {
        switch (operatorToken.getType()) {
            case 113: {
                return new UnaryOperatorPostIncrementNode(operatorToken, operand);
            }
            case 114: {
                return new UnaryOperatorPostDecrementNode(operatorToken, operand);
            }
        }
        assert (false) : "Token '" + operatorToken.getText() + "' unexpected in UnaryOperatorNodeBase.createPostfix()";
        return null;
    }

    public UnaryOperatorNodeBase(IASToken operatorToken, ExpressionNodeBase operandNode) {
        super(operatorToken);
        this.operandNode = operandNode;
    }

    protected UnaryOperatorNodeBase(UnaryOperatorNodeBase other) {
        super(other);
        this.operandNode = other.operandNode != null ? other.operandNode.copy() : null;
    }

    public int getChildCount() {
        return this.operandNode != null ? 1 : 0;
    }

    public IASNode getChild(int i) {
        return i == 0 ? this.operandNode : null;
    }

    protected void setChildren(boolean fillInOffsets) {
        if (this.operandNode != null) {
            this.operandNode.setParent(this);
        }
    }

    protected void fillInOffsets() {
        if (this.operandNode == null && this.operatorStart != -1) {
            this.span(this.operatorStart, this.operatorStart + 1, -1, -1, -1, -1);
        } else {
            super.fillInOffsets();
        }
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    public boolean isDynamicExpression(ICompilerProject project) {
        return false;
    }

    boolean isAttributeExpr(ExpressionNodeBase e) {
        return this.getOperator() == IOperatorNode.OperatorType.AT && e == this.getOperandNode();
    }

    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (this.isAttributeExpr(e) && (p = this.getParentExpression()) != null) {
            return p.getBaseForMemberRef(this);
        }
        return null;
    }

    public IOperatorNode.ExpressionType getExpressionType() {
        return IOperatorNode.ExpressionType.PREFIX;
    }

    public IExpressionNode getOperandNode() {
        return this.operandNode;
    }

    public void setExpression(ExpressionNodeBase operandNode) {
        this.operandNode = operandNode;
    }

    protected ITypeDefinition resolveIncrementOrDecrementType(ICompilerProject project) {
        ITypeDefinition exprType = this.operandNode.resolveType(project);
        if (exprType != null) {
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition uintType = project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT);
            if (exprType.equals(intType)) {
                return intType;
            }
            if (exprType.equals(uintType)) {
                return uintType;
            }
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
    }
}

