/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.AppliedVectorDefinitionFactory;
import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;

public class TypedExpressionNode
extends ExpressionNodeBase
implements ITypedExpressionNode {
    private final ExpressionNodeBase collectionNode;
    private final ExpressionNodeBase typeNode;
    private final int typeOperatorStart;
    private final int typeOperatorEnd;

    public TypedExpressionNode(ExpressionNodeBase collection, ExpressionNodeBase type, ASToken openToken) {
        assert (collection != null) : "collection type node can't be null";
        assert (type != null) : "type parameter node can't be null";
        this.collectionNode = collection;
        this.typeNode = type;
        if (openToken == null) {
            this.typeOperatorStart = -1;
            this.typeOperatorEnd = -1;
        } else {
            this.typeOperatorStart = openToken.getStart();
            this.typeOperatorEnd = openToken.getEnd();
        }
        this.span(collection, type);
    }

    public TypedExpressionNode(ExpressionNodeBase collection, ExpressionNodeBase type) {
        this(collection, type, null);
    }

    protected TypedExpressionNode(TypedExpressionNode other) {
        super(other);
        this.collectionNode = other.collectionNode != null ? other.collectionNode.copy() : null;
        this.typeNode = other.typeNode != null ? other.typeNode.copy() : null;
        this.typeOperatorStart = other.typeOperatorStart;
        this.typeOperatorEnd = other.typeOperatorEnd;
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.TypedExpressionID;
    }

    public int getChildCount() {
        if (this.typeNode != null && this.collectionNode != null) {
            return 2;
        }
        if (this.typeNode != null || this.collectionNode != null) {
            return 1;
        }
        return 0;
    }

    public IASNode getChild(int i) {
        switch (i) {
            case 0: {
                if (this.typeNode != null && this.collectionNode != null && this.typeNode.getAbsoluteStart() < this.collectionNode.getAbsoluteStart()) {
                    return this.typeNode;
                }
                return this.collectionNode;
            }
            case 1: {
                if (this.typeNode != null && this.collectionNode != null && this.typeNode.getAbsoluteStart() < this.collectionNode.getAbsoluteStart()) {
                    return this.collectionNode;
                }
                return this.typeNode;
            }
        }
        return null;
    }

    protected void setChildren(boolean fillInOffsets) {
        if (this.collectionNode != null) {
            this.collectionNode.setParent(this);
        }
        if (this.typeNode != null) {
            this.typeNode.setParent(this);
        }
    }

    public IDefinition resolve(ICompilerProject project) {
        IDefinition param;
        ITypeDefinition vectorDef;
        IDefinition base = this.collectionNode.resolve(project);
        IAppliedVectorDefinition resolvedType = null;
        if (base != null && base == (vectorDef = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR)) && (param = this.typeNode.resolve(project)) instanceof ITypeDefinition) {
            resolvedType = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)param);
        }
        return resolvedType;
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        IDefinition d = this.resolve(project);
        if (d != null) {
            return d.resolveType(project);
        }
        return null;
    }

    protected TypedExpressionNode copy() {
        return new TypedExpressionNode(this);
    }

    public Name getMName(ICompilerProject project) {
        IDefinition d = this.resolve(project);
        if (d != null) {
            return ((DefinitionBase)d).getMName(project);
        }
        return null;
    }

    public String computeSimpleReference() {
        return this.getName();
    }

    public IReference computeTypeReference() {
        IReference base = this.collectionNode.computeTypeReference();
        IReference param = this.typeNode.computeTypeReference();
        return ReferenceFactory.parameterizedReference(this.getWorkspace(), base, param);
    }

    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (this.collectionNode instanceof IIdentifierNode) {
            builder.append(((IIdentifierNode)((Object)this.collectionNode)).getName());
        }
        if (this.typeNode instanceof IIdentifierNode) {
            builder.append(".<");
            builder.append(((IIdentifierNode)((Object)this.typeNode)).getName());
            builder.append(">");
        }
        return builder.toString();
    }

    public IIdentifierNode.IdentifierType getIdentifierType() {
        return IIdentifierNode.IdentifierType.TYPED_NAME;
    }

    public IExpressionNode getCollectionNode() {
        return this.collectionNode;
    }

    public IExpressionNode getTypeNode() {
        return this.typeNode;
    }

    public boolean hasTypedOperator() {
        return this.typeOperatorStart != -1 && this.typeOperatorEnd != -1;
    }

    public int getTypedOperatorStart() {
        return this.typeOperatorStart;
    }

    public int getTypedOperatorEnd() {
        return this.typeOperatorEnd;
    }
}

