/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.abc.semantics.Name;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.references.INamespaceReference;
import org.apache.royale.compiler.definitions.references.IReference;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public class MemberAccessExpressionNode
extends BinaryOperatorNodeBase
implements IMemberAccessExpressionNode {
    private IOperatorNode.OperatorType operator = IOperatorNode.OperatorType.MEMBER_ACCESS;

    public MemberAccessExpressionNode(ExpressionNodeBase left, IASToken operatorToken, ExpressionNodeBase right) {
        super(operatorToken, left, right);
        if (operatorToken != null) {
            int tokenType = operatorToken.getType();
            if (tokenType == 36) {
                this.operator = IOperatorNode.OperatorType.MEMBER_ACCESS;
            } else if (tokenType == 155) {
                this.operator = IOperatorNode.OperatorType.DESCENDANT_ACCESS;
            } else assert (false) : "Unexpected token '" + operatorToken.getText() + "' for MemberAccessExpressionNode";
        }
    }

    public MemberAccessExpressionNode(MemberAccessExpressionNode other) {
        super(other);
        this.operator = other.operator;
    }

    public ASTNodeID getNodeID() {
        ASTNodeID nodeID = this.getOperator() == IOperatorNode.OperatorType.DESCENDANT_ACCESS ? ASTNodeID.Op_DescendantsID : (this.rightOperandNode != null && this.rightOperandNode.hasParenthesis() ? ASTNodeID.E4XFilterID : ASTNodeID.MemberAccessExpressionID);
        return nodeID;
    }

    public IDefinition resolve(ICompilerProject project) {
        if (this.isPackageReference()) {
            return null;
        }
        return this.rightOperandNode.resolve(project);
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        if (ASTNodeID.E4XFilterID == this.getNodeID()) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        }
        return this.rightOperandNode.resolveType(project);
    }

    public boolean isDynamicExpression(ICompilerProject project) {
        if (this.isPackageReference()) {
            return false;
        }
        return super.isDynamicExpression(project);
    }

    protected MemberAccessExpressionNode copy() {
        return new MemberAccessExpressionNode(this);
    }

    public Name getMName(ICompilerProject project) {
        return this.rightOperandNode.getMName(project);
    }

    String computeSimpleReference() {
        return this.getDisplayString();
    }

    IReference computeTypeReference() {
        return this.rightOperandNode.computeTypeReference();
    }

    public INamespaceReference computeNamespaceReference() {
        return this.rightOperandNode.computeNamespaceReference();
    }

    boolean isPartOfMemberRef(ExpressionNodeBase e) {
        IASNode p;
        if (e == this.rightOperandNode) {
            return true;
        }
        if (e == this.leftOperandNode && (p = this.getParent()) instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)p).isPartOfMemberRef(this);
        }
        return false;
    }

    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (e == this.rightOperandNode) {
            return this.leftOperandNode;
        }
        if (e == this.leftOperandNode && (p = this.getParentExpression()) != null) {
            return p.getBaseForMemberRef(this);
        }
        return null;
    }

    public IOperatorNode.OperatorType getOperator() {
        return this.operator;
    }

    public String getOperatorText() {
        switch (this.getNodeID()) {
            case E4XFilterID: {
                return ".()";
            }
        }
        return super.getOperatorText();
    }

    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        if (this.leftOperandNode != null && this.leftOperandNode instanceof IIdentifierNode) {
            builder.append(((IIdentifierNode)((Object)this.leftOperandNode)).getName());
        } else if (this.leftOperandNode != null && this.leftOperandNode instanceof MemberAccessExpressionNode) {
            builder.append(((MemberAccessExpressionNode)this.leftOperandNode).getDisplayString());
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        if (this.rightOperandNode != null && this.rightOperandNode instanceof IIdentifierNode) {
            builder.append(((IIdentifierNode)((Object)this.rightOperandNode)).getName());
        }
        return builder.toString();
    }

    public boolean isSuper(ExpressionNodeBase node) {
        if (!(node instanceof ILanguageIdentifierNode)) {
            return false;
        }
        ILanguageIdentifierNode idBase = (ILanguageIdentifierNode)((Object)node);
        return idBase.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER;
    }

    public boolean stemIsPackage() {
        return this.leftOperandNode.isPackageReference();
    }

    public void setStemAsPackage(boolean b) {
        this.leftOperandNode.setTreatAsPackage(b);
    }

    public boolean isMemberReference(IASNode node) {
        return node == this.rightOperandNode;
    }
}

