/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.internal.tree.as.FixedChildrenNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.parsing.IASToken;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IIterationFlowNode;

public class IterationFlowNode
extends FixedChildrenNode
implements IIterationFlowNode {
    private IdentifierNode labelNode;
    private IIterationFlowNode.IterationFlowKind kind;

    public IterationFlowNode(IASToken token) {
        if (token != null) {
            this.startBefore(token);
            switch (token.getType()) {
                case 63: {
                    this.kind = IIterationFlowNode.IterationFlowKind.BREAK;
                    break;
                }
                case 62: {
                    this.kind = IIterationFlowNode.IterationFlowKind.CONTINUE;
                    break;
                }
                case 14: {
                    this.kind = IIterationFlowNode.IterationFlowKind.GOTO;
                }
            }
            this.endAfter(token);
        }
    }

    public ASTNodeID getNodeID() {
        switch (this.kind) {
            case BREAK: {
                return ASTNodeID.BreakID;
            }
            case CONTINUE: {
                return ASTNodeID.ContinueID;
            }
            case GOTO: {
                return ASTNodeID.GotoID;
            }
        }
        assert (false) : "Unknown control flow type!";
        return ASTNodeID.UnknownID;
    }

    public int getChildCount() {
        return this.labelNode != null ? 1 : 0;
    }

    public IASNode getChild(int i) {
        if (i == 0) {
            return this.labelNode;
        }
        return null;
    }

    public IIterationFlowNode.IterationFlowKind getKind() {
        return this.kind;
    }

    public IIdentifierNode getLabelNode() {
        return this.labelNode;
    }

    public void setLabel(IdentifierNode labelNode) {
        this.labelNode = labelNode;
        labelNode.setParent(this);
        this.endAfter(labelNode);
    }
}

