/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.as;

import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;

public class DynamicAccessNode
extends BinaryOperatorNodeBase
implements IDynamicAccessNode {
    public DynamicAccessNode(ExpressionNodeBase leftOperandNode) {
        super(null, leftOperandNode, null);
    }

    protected DynamicAccessNode(DynamicAccessNode other) {
        super(other);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.ArrayIndexExpressionID;
    }

    protected DynamicAccessNode copy() {
        return new DynamicAccessNode(this);
    }

    public boolean isDynamicExpression(ICompilerProject project) {
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        if (leftType instanceof IAppliedVectorDefinition) {
            return super.isDynamicExpression(project);
        }
        return true;
    }

    public ITypeDefinition resolveType(ICompilerProject project) {
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        if (leftType instanceof IAppliedVectorDefinition && SemanticUtils.isNumericType(this.getRightOperandNode().resolveType(project), project)) {
            IAppliedVectorDefinition vectorDef = (IAppliedVectorDefinition)leftType;
            return vectorDef.resolveElementType(project);
        }
        return super.resolveType(project);
    }

    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.DYNAMIC_ACCESS;
    }
}

