/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.internal.parsing.as.ASToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataToken;
import org.apache.royale.compiler.internal.parsing.as.MetadataTokenizer;
import org.apache.royale.compiler.parsing.ICMToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataPayloadToken
extends ASToken {
    private List<MetadataToken> payload;
    private MetadataTokenizer tokenTransformer;

    public MetaDataPayloadToken(ASToken token) {
        super(37, token.getStart(), token.getEnd(), token.getLine(), token.getColumn(), "");
        this.setSourcePath(token.getSourcePath());
        this.payload = new ArrayList<MetadataToken>(5);
        this.tokenTransformer = new MetadataTokenizer();
        this.addToken(token);
    }

    public MetaDataPayloadToken(MetaDataPayloadToken token) {
        super(37, token.getStart(), token.getEnd(), token.getLine(), token.getColumn(), "");
        this.setSourcePath(token.getSourcePath());
        this.payload = token.payload;
    }

    @Override
    public ASToken clone() {
        return new MetaDataPayloadToken(this);
    }

    public void addToken(ASToken token) {
        MetadataToken metadataToken = this.tokenTransformer.transformToken(token);
        if (metadataToken != null) {
            this.payload.add(metadataToken);
            this.setEnd(token.getEnd());
        }
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (MetadataToken token : this.payload) {
            builder.append(token.getText());
        }
        return builder.toString();
    }

    public List<MetadataToken> getPayload() {
        return this.payload;
    }

    @Override
    public ICMToken changeType(int type) {
        return this;
    }

    @Override
    public void adjustLocation(int offsetAdjustment, int lineAdjustment, int columnAdjustment) {
        super.adjustLocation(offsetAdjustment, lineAdjustment, columnAdjustment);
        for (MetadataToken token : this.getPayload()) {
            token.adjustLocation(offsetAdjustment, lineAdjustment, columnAdjustment);
        }
    }
}

