/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.parsing.as;

import antlr.Token;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.royale.abc.ABCConstants;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.definitions.ConstantDefinition;
import org.apache.royale.compiler.internal.definitions.DefinitionBase;
import org.apache.royale.compiler.internal.parsing.as.BaseASParser;
import org.apache.royale.compiler.internal.parsing.as.ConfigCompilationUnit;
import org.apache.royale.compiler.internal.parsing.as.IProjectConfigVariables;
import org.apache.royale.compiler.internal.projects.ASProject;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.DefinitionPriority;
import org.apache.royale.compiler.internal.projects.ISourceFileHandler;
import org.apache.royale.compiler.internal.scopes.ASProjectScope;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.ConfigConstNode;
import org.apache.royale.compiler.internal.tree.as.ConfigExpressionNode;
import org.apache.royale.compiler.internal.tree.as.ConfigNamespaceNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LiteralNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.internal.tree.as.ScopedBlockNode;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.CannotResolveConfigExpressionProblem;
import org.apache.royale.compiler.problems.CannotResolveProjectLevelConfigExpressionProblem;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ConflictingNameInNamespaceProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem2;
import org.apache.royale.compiler.problems.NonConstantConfigInitProblem;
import org.apache.royale.compiler.problems.UndefinedConfigNamespaceProblem;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.units.ICompilationUnit;
import org.apache.royale.compiler.units.requests.ISyntaxTreeRequestResult;
import org.apache.royale.compiler.workspaces.IWorkspace;
import org.apache.royale.utils.FilenameNormalization;

public class ConfigProcessor {
    private ScopedBlockNode configScope;
    private BaseASParser parser;
    private boolean transferringConstants;
    private ConfigProject backingProject;
    private IProjectConfigVariables variables;
    private ConfigCompilationUnit configUnit;
    private HashSet<String> configNames;
    private final IWorkspace workspace;

    ConfigProcessor(IWorkspace workspace, BaseASParser parser) {
        this.parser = parser;
        this.configNames = new HashSet();
        this.configNames.add("CONFIG");
        this.workspace = workspace;
    }

    public void connect(IProjectConfigVariables variables) {
        this.variables = variables;
        if (variables != null) {
            List<String> namespaces = variables.getConfigNamespaceNames();
            for (String namespace : namespaces) {
                this.configNames.add(namespace);
            }
        }
    }

    public void disconnect() {
        if (this.configUnit != null) {
            this.backingProject.removeCU(this.configUnit);
        }
        if (this.backingProject != null) {
            this.backingProject = null;
        }
        this.parser = null;
    }

    public final boolean isConfigNamespace(String name) {
        return this.configNames.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initConfigStructures() {
        if (this.backingProject == null) {
            this.backingProject = new ConfigProject(this.workspace);
            String configFileName = FilenameNormalization.normalize("config" + Integer.toString(this.hashCode()) + ".config");
            try {
                this.backingProject.setIncludeSources(new File[]{new File(configFileName)});
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Collection<ICompilationUnit> units = this.backingProject.getCompilationUnits(configFileName);
            assert (units.size() == 1 && Iterables.getOnlyElement(units) instanceof ConfigCompilationUnit);
            try {
                try {
                    this.transferringConstants = true;
                    ISyntaxTreeRequestResult treeResult = ((ICompilationUnit)Iterables.getOnlyElement(units)).getSyntaxTreeRequest().get();
                    this.configScope = ((ConfigCompilationUnit.ConfigFileNode)treeResult.getAST()).getTargetConfigScope();
                    this.addConditionalCompilationNamespace(new ConfigNamespaceNode(new IdentifierNode("CONFIG", (Token)null)));
                    if (this.variables != null) {
                        if (this.variables != null) {
                            List<IDefinition> definitions = this.variables.getRequiredDefinitions();
                            ConfigProject.ConfigProjectScope scope = this.backingProject.getScope();
                            for (IDefinition def : definitions) {
                                if (def == null || scope.getLocalDefinitionSetByName(def.getQualifiedName()) != null) continue;
                                scope.addConfigDefinition(def);
                            }
                        }
                        List<ConfigNamespaceNode> namespaces = this.variables.getConfigNamespaces();
                        for (ConfigNamespaceNode ns : namespaces) {
                            this.addConditionalCompilationNamespace(ns);
                        }
                        List<ConfigConstNode> vars = this.variables.getConfigVariables();
                        for (ConfigConstNode var : vars) {
                            this.addConfigConstNode(var);
                        }
                    }
                    Object var9_11 = null;
                    this.transferringConstants = false;
                }
                catch (InterruptedException e) {
                    InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.parser.getFilename(), e, "ConfigProcessor");
                    this.addProblem(problem);
                    Object var9_12 = null;
                    this.transferringConstants = false;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                this.transferringConstants = false;
                throw throwable;
            }
        }
    }

    public IASNode[] getConfigChildren() {
        if (this.configScope != null) {
            int childCount = this.configScope.getChildCount();
            ArrayList<NodeBase> children = new ArrayList<NodeBase>(childCount);
            for (int i = 0; i < childCount; ++i) {
                NodeBase child = (NodeBase)this.configScope.getChild(i);
                child.setParent(null);
                if (child instanceof ConfigConstNode) {
                    ((ConfigConstNode)child).reset();
                }
                children.add(child);
            }
            return children.toArray(new IASNode[0]);
        }
        return new IASNode[0];
    }

    public boolean addConditionalCompilationNamespace(NamespaceNode node) {
        this.initConfigStructures();
        IDefinitionSet name = this.configScope.getASScope().getLocalDefinitionSetByName(node.getName());
        if (name != null) {
            return true;
        }
        node.normalize(true);
        this.configScope.addItemAfterNormalization(node);
        this.configScope.getASScope().addDefinition(node.getDefinition());
        this.configNames.add(node.getName());
        return true;
    }

    public boolean addConfigConstNode(ConfigConstNode node) {
        ExpressionNodeBase problemLocationNode;
        ConfigConstNode.ConfigDefinition cdef;
        IExpressionNode initializer;
        ConstantDefinition def;
        Object value;
        this.initConfigStructures();
        node.normalize(true);
        IdentifierNode configNamespaceNode = (IdentifierNode)((Object)node.getNamespaceNode());
        IDefinitionSet set = this.configScope.getASScope().getLocalDefinitionSetByName(configNamespaceNode.getName());
        if (set == null) {
            IdentifierNode namespaceNode = (IdentifierNode)((Object)node.getNamespaceNode());
            UndefinedConfigNamespaceProblem problem = new UndefinedConfigNamespaceProblem(namespaceNode, namespaceNode.getName());
            this.addProblem(problem);
            return false;
        }
        this.configScope.addItemAfterNormalization(node);
        DefinitionBase constDef = node.getDefinition();
        this.configScope.getASScope().addDefinition(constDef);
        if (constDef instanceof ConstantDefinition && (value = (def = (ConstantDefinition)constDef).resolveValue(this.backingProject)) == ConfigConstNode.UNKNOWN_VALUE && def instanceof ConfigConstNode.ConfigDefinition && (initializer = (cdef = (ConfigConstNode.ConfigDefinition)def).getInitializer()).getNodeID() != ASTNodeID.MemberAccessExpressionID && initializer.getNodeID() != ASTNodeID.IdentifierID && (problemLocationNode = node.getAssignedValueNode()) != null) {
            NonConstantConfigInitProblem problem = new NonConstantConfigInitProblem(problemLocationNode);
            this.addProblem(problem);
        }
        if (SemanticUtils.getMultiDefinitionType(constDef, this.backingProject) != SemanticUtils.MultiDefinitionType.NONE) {
            this.addProblem(new ConflictingNameInNamespaceProblem(node, constDef.getBaseName(), node.getNamespace()));
            return false;
        }
        return true;
    }

    private void addProblem(ICompilerProblem problem) {
        if (!this.transferringConstants) {
            this.parser.addProblem(problem);
        }
    }

    protected Object evaluateConstNodeExpressionToJavaObject(ConfigExpressionNode node) {
        this.initConfigStructures();
        node.normalize(true);
        this.configScope.addItemAfterNormalization(node);
        Object result = node.resolveConfigValue(this.backingProject);
        if (result == null || result == ConfigConstNode.UNKNOWN_VALUE) {
            ConfigConstNode.ConfigDefinition def;
            IExpressionNode initializer;
            IDefinition definition = node.resolve(this.backingProject);
            if (definition instanceof ConfigConstNode.ConfigDefinition && ((initializer = (def = (ConfigConstNode.ConfigDefinition)definition).getInitializer()).getNodeID() == ASTNodeID.MemberAccessExpressionID || initializer.getNodeID() == ASTNodeID.IdentifierID)) {
                return initializer;
            }
            CompilerProblem problem = this.isFromProjectConfigVariables() ? new CannotResolveProjectLevelConfigExpressionProblem(node.getConfigValue()) : new CannotResolveConfigExpressionProblem(node, node.getConfigValue());
            this.addProblem(problem);
        }
        return result;
    }

    private boolean isFromProjectConfigVariables() {
        return this.parser.isParsingProjectConfigVariables();
    }

    protected IASNode evaluateConstNodeExpression(ConfigExpressionNode node) {
        Object result = this.evaluateConstNodeExpressionToJavaObject(node);
        if (result instanceof Boolean) {
            LiteralNode literalNode = new LiteralNode(ILiteralNode.LiteralType.BOOLEAN, ((Boolean)result).toString());
            literalNode.setSynthetic(true);
            return literalNode;
        }
        if (result instanceof String) {
            LiteralNode literalNode = new LiteralNode(ILiteralNode.LiteralType.STRING, (String)result);
            literalNode.setSynthetic(true);
            return literalNode;
        }
        if (result instanceof Double || result instanceof Integer || result instanceof Long) {
            NumericLiteralNode literalNode = new NumericLiteralNode(result.toString());
            literalNode.setSynthetic(true);
            return literalNode;
        }
        if (result == ABCConstants.NULL_VALUE) {
            LiteralNode literalNode = new LiteralNode(ILiteralNode.LiteralType.NULL, "Null");
            literalNode.setSynthetic(true);
            return literalNode;
        }
        if (result instanceof MemberAccessExpressionNode) {
            MemberAccessExpressionNode mae = (MemberAccessExpressionNode)result;
            return mae;
        }
        if (result instanceof IdentifierNode) {
            IdentifierNode id = (IdentifierNode)result;
            return id;
        }
        if (result instanceof Namespace) {
            Namespace ns = (Namespace)result;
            String nsName = ns.getName();
            if (nsName.length() == 0) {
                nsName = "public";
            }
            return new IdentifierNode(nsName);
        }
        return null;
    }

    public final void setParser(BaseASParser parser) {
        this.parser = parser;
    }

    public final void detachParser(BaseASParser parser) {
        if (this.parser == parser) {
            this.parser = null;
        }
    }

    final class ConfigProject
    extends ASProject {
        private ConfigProject(IWorkspace w) {
            super((Workspace)w, true);
            this.getSourceCompilationUnitFactory().addHandler(new ISourceFileHandler(){

                public String[] getExtensions() {
                    return new String[]{"config"};
                }

                public ICompilationUnit createCompilationUnit(CompilerProject project, String path, DefinitionPriority.BasePriority priority, int order, String qname, String locale) {
                    return new ConfigCompilationUnit(ConfigProcessor.this.backingProject, path);
                }

                public boolean needCompilationUnit(CompilerProject project, String path, String qname, String locale) {
                    return true;
                }

                public boolean canCreateInvisibleCompilationUnit() {
                    return false;
                }
            });
        }

        protected ASProjectScope initProjectScope(CompilerProject project) {
            return new ConfigProjectScope(project);
        }

        public ConfigProjectScope getScope() {
            return (ConfigProjectScope)super.getScope();
        }

        public void removeCU(ConfigCompilationUnit cu) {
            this.removeCompilationUnits(Collections.singletonList(cu));
        }

        public boolean getAllowPrivateNameConflicts() {
            return false;
        }

        public boolean getAllowImportAliases() {
            return false;
        }

        public boolean getAllowAbstractClasses() {
            return false;
        }

        public boolean getAllowPrivateConstructors() {
            return false;
        }

        final class ConfigProjectScope
        extends ASProjectScope {
            private ConfigProjectScope(CompilerProject project) {
                super(project);
            }

            public void addConfigDefinition(IDefinition definition) {
                this.addDefinitionToStore(definition);
            }
        }
    }
}

