/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.filters;

import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.filters.AbstractFilterNode;
import org.apache.royale.compiler.problems.FXGInvalidColorMatrixValueProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorMatrixFilterNode
extends AbstractFilterNode {
    public float[] matrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    @Override
    public String getNodeName() {
        return "ColorMatrixFilter";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("matrix".equals(name)) {
            this.matrix = this.get4x5FloatMatrix(value, name, this.matrix, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    protected float[] get4x5FloatMatrix(String value, String name, float[] defaultMatrix, Collection<ICompilerProblem> problems) {
        float[] result = new float[20];
        StringTokenizer tokenizer = new StringTokenizer(value, ",", false);
        try {
            for (int index = 0; tokenizer.hasMoreTokens() && index < 20; index = (int)((byte)(index + 1))) {
                String token = tokenizer.nextToken();
                float f = DOMParserHelper.parseFloat(this, token);
                int n = index;
                result[n] = f;
            }
        }
        catch (Exception e) {
            problems.add(new FXGInvalidColorMatrixValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), value));
            return defaultMatrix;
        }
        return result;
    }
}

