/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.definitions;

import org.apache.royale.compiler.definitions.IGetterDefinition;
import org.apache.royale.compiler.definitions.ISetterDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.GetterDefinition;
import org.apache.royale.compiler.projects.ICompilerProject;

public class SetterDefinition
extends AccessorDefinition
implements ISetterDefinition {
    public SetterDefinition(String name) {
        super(name);
    }

    public IGetterDefinition resolveGetter(ICompilerProject project) {
        return (IGetterDefinition)((Object)this.resolveCorrespondingAccessor(project));
    }

    public boolean isSkinPart() {
        return this.getSkinPart() != null;
    }

    public boolean isRequiredSkinPart() {
        IMetaTag skinPart = this.getSkinPart();
        if (skinPart == null) {
            return false;
        }
        return this.isRequiredSkinPart(skinPart);
    }

    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        if (this.isStatic()) {
            sb.append("static");
            sb.append(' ');
        }
        sb.append("function");
        sb.append(' ');
        sb.append("set");
        sb.append(' ');
        sb.append(this.getBaseName());
        sb.append('(');
        sb.append(this.getTypeAsDisplayString());
        sb.append(')');
        sb.append(':');
        sb.append("void");
    }

    public FunctionDefinition resolveOverriddenFunction(ICompilerProject project) {
        FunctionDefinition override = super.resolveOverriddenFunction(project);
        if (override instanceof GetterDefinition) {
            override = ((GetterDefinition)override).resolveCorrespondingAccessor(project);
        }
        return override;
    }
}

