/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.caches;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipFile;
import org.apache.royale.compiler.caches.ISWFCache;
import org.apache.royale.compiler.internal.caches.CacheStoreKeyBase;
import org.apache.royale.compiler.internal.caches.ConcurrentCacheStoreBase;
import org.apache.royale.compiler.problems.FileInLibraryNotFoundProblem;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.SWC;
import org.apache.royale.swc.SWCManager;
import org.apache.royale.swc.io.SWCReader;
import org.apache.royale.swf.ITagContainer;
import org.apache.royale.swf.io.SWFReader;
import org.apache.royale.swf.tags.DoABCTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.swf.tags.SymbolClassTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWFCache
extends ConcurrentCacheStoreBase<ITagContainer>
implements ISWFCache {
    public static SWFInSWCCacheKey createKey(ISWC swc, String swfPath) {
        assert (swc != null);
        assert (swfPath != null);
        SWFInSWCCacheKey key = new SWFInSWCCacheKey();
        key.swc = swc;
        key.swfPath = swfPath;
        return key;
    }

    public static SWFFileCacheKey createKey(String swfFileName) {
        SWFFileCacheKey key = new SWFFileCacheKey();
        key.fileName = swfFileName.intern();
        return key;
    }

    public static DoABCTag findDoABCTagByName(ITagContainer tags, String abcName) {
        assert (abcName != null && !"".equals(abcName)) : "expect ABC name.";
        for (ITag tag : tags) {
            DoABCTag abcTag;
            if (!(tag instanceof DoABCTag) || !(abcTag = (DoABCTag)tag).getName().equals(abcName)) continue;
            return abcTag;
        }
        return null;
    }

    public static Collection<SymbolClassTag> findAllSymbolClassTags(ITagContainer tags) {
        ArrayList<SymbolClassTag> symbolTags = new ArrayList<SymbolClassTag>();
        for (ITag tag : tags) {
            if (!(tag instanceof SymbolClassTag)) continue;
            symbolTags.add((SymbolClassTag)tag);
        }
        return symbolTags;
    }

    public SWFCache(SWCManager swcManager) {
    }

    @Override
    protected ITagContainer createEntryValue(CacheStoreKeyBase key) {
        if (!(key instanceof SWFCacheKey)) {
            throw new IllegalArgumentException("expect SWFCacheKey but got " + key.getClass().getSimpleName());
        }
        try {
            SWFReader swfReader = new SWFReader(false);
            this.readInputStream(swfReader, (SWFCacheKey)key);
            return swfReader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readInputStream(SWFReader swfReader, SWFCacheKey swfCacheKey) throws IOException {
        swfCacheKey.readSWF(swfReader);
    }

    protected static class SWFFileCacheKey
    extends SWFCacheKey {
        private String fileName;

        public String generateKey() {
            return this.fileName.intern();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readSWF(SWFReader swfReader) throws IOException {
            InputStream swfInputStream = new FileInputStream(this.fileName);
            try {
                swfInputStream = new BufferedInputStream(swfInputStream);
                swfReader.readFrom(swfInputStream, this.fileName);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                swfInputStream.close();
                throw throwable;
            }
            swfInputStream.close();
        }
    }

    protected static class SWFInSWCCacheKey
    extends SWFCacheKey {
        protected ISWC swc;
        protected String swfPath;

        public String generateKey() {
            return String.format("%s:%s", this.swc.getSWCFile().getAbsolutePath(), this.swfPath).intern();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void readSWF(SWFReader swfReader) throws IOException {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.swc.getSWCFile(), 1);
                InputStream swfInputStream = SWCReader.getInputStream(zipFile, this.swfPath);
                if (swfInputStream != null) {
                    swfInputStream = new BufferedInputStream(swfInputStream);
                    swfReader.readFrom(swfInputStream, SWCReader.getReportingPath(this.swc.getSWCFile().getAbsolutePath(), this.swfPath));
                } else if (this.swc instanceof SWC) {
                    ((SWC)this.swc).addProblem(new FileInLibraryNotFoundProblem(this.swfPath, this.swc.getSWCFile().getAbsolutePath()));
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                zipFile.close();
                throw throwable;
            }
            zipFile.close();
        }
    }

    private static abstract class SWFCacheKey
    extends CacheStoreKeyBase {
        abstract void readSWF(SWFReader var1) throws IOException;
    }
}

