/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import java.util.Collection;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.tree.as.ClassNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.ImportNode;
import org.apache.royale.compiler.internal.tree.as.InterfaceNode;
import org.apache.royale.compiler.internal.tree.as.NamespaceIdentifierNode;
import org.apache.royale.compiler.internal.tree.as.PackageNode;
import org.apache.royale.compiler.internal.tree.as.VariableNode;
import org.apache.royale.compiler.problems.BURMDiagnosticNotAllowedHereProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDocumentNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectiveProcessor {
    private Collection<ICompilerProblem> problems = null;

    protected DirectiveProcessor(Collection<ICompilerProblem> problems) {
        this.problems = problems;
    }

    void declareClass(ClassNode c) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(c));
    }

    void declareInterface(InterfaceNode in) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(in));
    }

    void declareFunction(FunctionNode f) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(f));
    }

    void declarePackage(PackageNode p) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(p));
    }

    void declareVariable(VariableNode var) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(var));
    }

    void declareBindableVariable(VariableNode var) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(var));
    }

    void declareMXMLDocument(IMXMLDocumentNode d) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(d));
    }

    void processDirective(IASNode n) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(n));
    }

    void processNamespaceIdentifierDirective(NamespaceIdentifierNode ns) {
        this.problems.add(new BURMDiagnosticNotAllowedHereProblem(ns));
    }

    void processImportDirective(ImportNode imp) {
        this.processDirective(imp);
    }

    void processConfigBlock(IASNode n) {
        this.traverse(n);
    }

    void traverse(IASNode root) {
        for (int i = 0; root != null && i < root.getChildCount(); ++i) {
            this.processNode(root.getChild(i));
        }
    }

    void processNode(IASNode n) {
        if (n == null) {
            return;
        }
        switch (n.getNodeID()) {
            case ClassID: {
                this.declareClass((ClassNode)n);
                break;
            }
            case InterfaceID: {
                this.declareInterface((InterfaceNode)n);
                break;
            }
            case FunctionID: 
            case GetterID: 
            case SetterID: {
                this.declareFunction((FunctionNode)n);
                break;
            }
            case ImportID: {
                this.processImportDirective((ImportNode)n);
                break;
            }
            case NamespaceIdentifierID: {
                this.processNamespaceIdentifierDirective((NamespaceIdentifierNode)n);
                break;
            }
            case PackageID: {
                this.declarePackage((PackageNode)n);
                break;
            }
            case VariableID: {
                this.declareVariable((VariableNode)n);
                break;
            }
            case BindableVariableID: {
                this.declareBindableVariable((VariableNode)n);
                break;
            }
            case MXMLDocumentID: {
                this.declareMXMLDocument((IMXMLDocumentNode)n);
                break;
            }
            case MetaTagsID: {
                break;
            }
            case ConfigBlockID: {
                this.processConfigBlock(n);
                break;
            }
            default: {
                IASNode parent;
                IdentifierNode node;
                if (n.getNodeID() == ASTNodeID.IdentifierID && (node = (IdentifierNode)n).getName().equals("override") && (parent = node.getParent()).getNodeID() == ASTNodeID.ConfigBlockID) {
                    IASNode parentOfMethods = parent.getParent();
                    int functionCount = parentOfMethods.getChildCount();
                    for (int i = 0; i < functionCount; ++i) {
                        IASNode child = parentOfMethods.getChild(i);
                        if (child != parent || !((child = parentOfMethods.getChild(i + 1)) instanceof IFunctionNode)) continue;
                        IFunctionNode fnode = (IFunctionNode)child;
                        FunctionDefinition fdef = (FunctionDefinition)fnode.getDefinition();
                        fdef.setOverride();
                        return;
                    }
                }
                this.processDirective(n);
            }
        }
    }

    public static int functionTraitKind(FunctionNode func, int default_kind) {
        switch (func.getNodeID()) {
            case GetterID: {
                return 2;
            }
            case SetterID: {
                return 3;
            }
        }
        return default_kind;
    }
}

