/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.common;

import java.util.HashSet;
import java.util.Set;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.semantics.Namespace;
import org.apache.royale.abc.semantics.Nsset;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.internal.definitions.NamespaceDefinition;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.projects.ICompilerProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multiname {
    private final Set<INamespaceDefinition> namespaceSet;
    private final String baseName;

    public static Multiname crackDottedQName(ICompilerProject project, String name) {
        return Multiname.crackDottedQName(project, name, false);
    }

    public static Multiname crackDottedQName(ICompilerProject project, String name, boolean includeInternal) {
        Workspace workspace = (Workspace)project.getWorkspace();
        HashSet<INamespaceDefinition> namespaceSet = new HashSet<INamespaceDefinition>(includeInternal ? 2 : 1);
        if (name != null) {
            int lastIndexOfDot;
            int n = lastIndexOfDot = name != null ? name.lastIndexOf(46) : -1;
            if (lastIndexOfDot != -1) {
                String definitionName = name.substring(lastIndexOfDot + 1);
                String packageName = name.substring(0, lastIndexOfDot);
                INamespaceDefinition.ILanguageNamespaceDefinition publicPackageNS = workspace.getPackageNamespaceDefinitionCache().get(packageName, false);
                namespaceSet.add(publicPackageNS);
                if (includeInternal) {
                    INamespaceDefinition.ILanguageNamespaceDefinition internalPackageNS = workspace.getPackageNamespaceDefinitionCache().get(packageName, true);
                    namespaceSet.add(internalPackageNS);
                }
                return new Multiname(namespaceSet, definitionName);
            }
            if (name.equals("Vector")) {
                INamespaceDefinition.ILanguageNamespaceDefinition vectorPackageNS = workspace.getPackageNamespaceDefinitionCache().get("__AS3__.vec", false);
                namespaceSet.add(vectorPackageNS);
                return new Multiname(namespaceSet, name);
            }
        }
        INamespaceDefinition.IPublicNamespaceDefinition publicPackageNS = NamespaceDefinition.getPublicNamespaceDefinition();
        namespaceSet.add(publicPackageNS);
        if (includeInternal) {
            INamespaceDefinition.ILanguageNamespaceDefinition internalPackageNS = workspace.getPackageNamespaceDefinitionCache().get("", true);
            namespaceSet.add(internalPackageNS);
        }
        return new Multiname(namespaceSet, name);
    }

    public static String getPackageNameForQName(String name) {
        if (name == null) {
            return "";
        }
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            return name.substring(0, lastIndexOfDot);
        }
        return "";
    }

    public static String getBaseNameForQName(String name) {
        int lastIndexOfDot = name.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            return name.substring(lastIndexOfDot + 1);
        }
        return name;
    }

    public static Multiname create(Set<INamespaceDefinition> nsset, String baseName) {
        return new Multiname(nsset, baseName);
    }

    public Multiname(Set<INamespaceDefinition> namespaceSet, String baseName) {
        this.namespaceSet = namespaceSet;
        this.baseName = baseName;
    }

    public Set<INamespaceDefinition> getNamespaceSet() {
        return this.namespaceSet;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Name getMName() {
        HashSet<Namespace> namespaces = new HashSet<Namespace>(this.namespaceSet.size());
        for (INamespaceDefinition ns : this.namespaceSet) {
            namespaces.add(((NamespaceDefinition)ns).getAETNamespace());
        }
        return new Name(new Nsset(namespaces), this.getBaseName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (INamespaceDefinition namespace : this.namespaceSet) {
            builder.append(namespace.toString());
            builder.append(", ");
        }
        builder.append("]::");
        builder.append(this.baseName);
        return builder.toString();
    }
}

