/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.flex.tools.FlexTool;
import org.apache.royale.compiler.Messages;
import org.apache.royale.compiler.clients.MXMLC;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.Configurator;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.COMPCConfiguration;
import org.apache.royale.compiler.internal.parsing.as.SimpleASDocDelegate;
import org.apache.royale.compiler.internal.targets.SWFTarget;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MissingRequirementConfigurationProblem;
import org.apache.royale.compiler.targets.ISWCTarget;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.swc.ISWC;
import org.apache.royale.swc.io.SWCDirectoryWriter;
import org.apache.royale.swc.io.SWCWriter;
import org.apache.royale.swf.io.SizeReportWritingSWFWriter;
import org.apache.royale.utils.FilenameNormalization;

public class ASDOC
extends MXMLC
implements FlexTool {
    private String asdocOutputMessage;

    public static void main(String[] args) {
        int exitCode = ASDOC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        ASDOC asdoc = new ASDOC();
        return asdoc.mainNoExit(args);
    }

    public ASDOC() {
        this.workspace.setASDocDelegate(new SimpleASDocDelegate());
    }

    public String getName() {
        return "ASDOC";
    }

    public int execute(String[] args) {
        return this.mainNoExit(args);
    }

    public boolean configure(String[] args) {
        return super.configure(args);
    }

    protected String getConfigurationDefaultVariable() {
        return "include-classes";
    }

    protected Configurator createConfigurator() {
        return new Configurator(COMPCConfiguration.class);
    }

    protected String getProgramName() {
        return "asdoc";
    }

    protected String getStartMessage() {
        String message = "Apache Royale ASDoc Compiler" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    protected void buildArtifact() throws InterruptedException, IOException {
        String outputOptionValue = this.config.getOutput();
        if (outputOptionValue == null || outputOptionValue.length() == 0) {
            MissingRequirementConfigurationProblem problem = new MissingRequirementConfigurationProblem("output");
            this.problems.add(problem);
            return;
        }
        ITargetSettings targetSettings = this.projectConfigurator.getTargetSettings(ITarget.TargetType.SWC);
        if (targetSettings == null) {
            return;
        }
        ISWCTarget swcTarget = this.project.createSWCTarget(targetSettings, null);
        this.target = (SWFTarget)swcTarget.getLibrarySWFTarget();
        ArrayList<ICompilerProblem> swcProblems = new ArrayList<ICompilerProblem>();
        ISWC swc = swcTarget.build(swcProblems);
        this.problems.addAll(swcProblems);
        if (!this.config.getCreateTargetWithErrors() && this.problems.hasErrors()) {
            return;
        }
        boolean useCompression = targetSettings.useCompression();
        if (this.config.getOutputSwcAsDirectory()) {
            String path = FilenameNormalization.normalize(outputOptionValue);
            SWCDirectoryWriter swcWriter = new SWCDirectoryWriter(path, useCompression, targetSettings.isDebugEnabled(), targetSettings.isTelemetryEnabled(), SizeReportWritingSWFWriter.getSWFWriterFactory(targetSettings.getSizeReport()));
            swcWriter.write(swc);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("path", path);
            params.put("seconds", seconds);
            this.asdocOutputMessage = Messages.getString("COMPC.swc_written_open_directory_in_seconds_format", params);
        } else {
            SWCWriter swcWriter = new SWCWriter(outputOptionValue, useCompression, targetSettings.isDebugEnabled(), targetSettings.isTelemetryEnabled(), targetSettings.getSWFMetadataDate(), targetSettings.getSWFMetadataDateFormat(), SizeReportWritingSWFWriter.getSWFWriterFactory(targetSettings.getSizeReport()));
            swcWriter.write(swc);
            File outputFile = new File(outputOptionValue);
            long endTime = System.nanoTime();
            String seconds = String.format("%5.3f", (double)(endTime - this.startTime) / 1.0E9);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("byteCount", outputFile.length());
            params.put("path", outputFile.getCanonicalPath());
            params.put("seconds", seconds);
            this.asdocOutputMessage = Messages.getString("MXMLC.bytes_written_to_file_in_seconds_format", params);
        }
    }

    protected void reportTargetCompletion() {
        if (this.asdocOutputMessage != null) {
            this.println(this.asdocOutputMessage);
        }
    }

    protected boolean setupTargetFile() throws InterruptedException {
        return true;
    }

    protected void validateTargetFile() throws ConfigurationException {
    }

    protected boolean isCompc() {
        return true;
    }

    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }
}

