/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IVariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarDeclarationEmitter
extends JSSubEmitter
implements ISubEmitter<IVariableNode> {
    public VarDeclarationEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IVariableNode node) {
        boolean hasVariableType;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        this.getModel().getVars().add(node);
        boolean defaultInitializers = false;
        ICompilerProject project = this.getProject();
        if (project instanceof RoyaleJSProject) {
            RoyaleJSProject fjsProject = (RoyaleJSProject)project;
            if (fjsProject.config != null) {
                defaultInitializers = fjsProject.config.getJsDefaultInitializers();
            }
        }
        boolean needsDefaultValue = EmitterUtils.needsDefaultValue(node, defaultInitializers, this.getProject());
        IFunctionNode parentFnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        boolean isHoisting = fjs.isEmittingHoistedNodes(parentFnNode);
        if (!(node instanceof ChainedVariableNode) && !isHoisting && needsDefaultValue) {
            this.write("//");
        }
        if (!(node instanceof ChainedVariableNode) && !node.isConst()) {
            fjs.emitMemberKeyword((IDefinitionNode)node);
        }
        IExpressionNode variableTypeNode = node.getVariableTypeNode();
        IDefinition variableDef = null;
        boolean bl = hasVariableType = variableTypeNode.getLine() >= 0;
        if (hasVariableType) {
            variableDef = variableTypeNode.resolve(this.getProject());
            this.startMapping((ISourceLocation)variableTypeNode, variableTypeNode.getLine(), variableTypeNode.getColumn() - 1);
        } else {
            IExpressionNode nameExpressionNode = node.getNameExpressionNode();
            this.startMapping((ISourceLocation)variableTypeNode, nameExpressionNode.getLine(), nameExpressionNode.getColumn() + nameExpressionNode.getAbsoluteEnd() - nameExpressionNode.getAbsoluteStart());
        }
        IExpressionNode avnode = node.getAssignedValueNode();
        ITypeDefinition avtypedef = null;
        if (avnode != null) {
            avtypedef = avnode.resolveType(this.getProject());
            String opcode = avnode.getNodeID().getParaphrase();
            if (opcode != "AnonymousFunction") {
                fjs.getDocEmitter().emitVarDoc(node, (IDefinition)avtypedef, this.getProject());
            }
        } else {
            fjs.getDocEmitter().emitVarDoc(node, null, this.getProject());
        }
        this.endMapping((ISourceLocation)variableTypeNode);
        if (!(node instanceof ChainedVariableNode) && node.isConst()) {
            fjs.emitMemberKeyword((IDefinitionNode)node);
        }
        fjs.emitDeclarationName((IDefinitionNode)node);
        if (avnode == null) {
            this.emitDefaultInitializer(node, defaultInitializers);
        } else if (!(avnode instanceof IEmbedNode)) {
            if (hasVariableType) {
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getVariableTypeNode());
            } else {
                this.startMapping((ISourceLocation)node, (ISourceLocation)node.getNameExpressionNode());
            }
            this.write(ASEmitterTokens.SPACE);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.endMapping((ISourceLocation)node);
            this.getEmitter().emitAssignmentCoercion(avnode, variableDef);
        }
        this.emitChainedVariables(node, defaultInitializers, isHoisting);
    }

    private void emitDefaultInitializer(IVariableNode node, boolean defaultInitializers) {
        ITypeDefinition typedef = null;
        IExpressionNode enode = node.getVariableTypeNode();
        if (enode != null) {
            typedef = enode.resolveType(this.getProject());
        }
        if (typedef != null && node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getNodeID() != ASTNodeID.Op_InID) {
            String defName = typedef.getQualifiedName();
            if (defName.equals("int") || defName.equals("uint")) {
                this.write(ASEmitterTokens.SPACE);
                this.writeToken(ASEmitterTokens.EQUAL);
                this.write("0");
            } else if (defaultInitializers) {
                if (defName.equals("Number")) {
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write("NaN");
                } else if (defName.equals("Boolean")) {
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write("false");
                } else if (!defName.equals("*")) {
                    this.write(ASEmitterTokens.SPACE);
                    this.writeToken(ASEmitterTokens.EQUAL);
                    this.write("null");
                }
            }
        }
    }

    private void emitChainedVariables(IVariableNode node, boolean defaultInitializers, boolean isHoisting) {
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        if (!(node instanceof ChainedVariableNode)) {
            IASNode child;
            int i;
            int len = node.getChildCount();
            boolean splitVariables = false;
            for (i = 0; i < len; ++i) {
                ChainedVariableNode varChild;
                child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode) || !EmitterUtils.needsDefaultValue((IVariableNode)(varChild = (ChainedVariableNode)child), defaultInitializers, this.getProject())) continue;
                splitVariables = true;
                break;
            }
            for (i = 0; i < len; ++i) {
                child = node.getChild(i);
                if (!(child instanceof ChainedVariableNode)) continue;
                if (splitVariables) {
                    boolean childNeedsDefault = EmitterUtils.needsDefaultValue((IVariableNode)child, defaultInitializers, this.getProject());
                    if (isHoisting && !childNeedsDefault) continue;
                    this.startMapping((ISourceLocation)node, (ISourceLocation)node.getChild(i - 1));
                    this.write(ASEmitterTokens.SEMICOLON);
                    this.endMapping((ISourceLocation)node);
                    this.writeNewline();
                    if (!isHoisting && childNeedsDefault) {
                        this.write("//");
                    }
                    this.writeToken(ASEmitterTokens.VAR);
                } else {
                    this.startMapping((ISourceLocation)node, (ISourceLocation)node.getChild(i - 1));
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.endMapping((ISourceLocation)node);
                }
                fjs.emitVarDeclaration((IVariableNode)child);
            }
        }
    }
}

