/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ASModifier;
import org.apache.royale.compiler.common.ModifiersSet;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.driver.js.goog.JSGoogConfiguration;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.tree.as.SetterNode;
import org.apache.royale.compiler.problems.UnknownTypeProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.scopes.IDefinitionSet;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagNode;
import org.apache.royale.compiler.tree.metadata.IMetaTagsNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFooterEmitter
extends JSSubEmitter
implements ISubEmitter<IPackageDefinition> {
    private ArrayList<VariableData> varData;
    private ArrayList<AccessorData> accessorData;
    private ArrayList<MethodData> methodData;
    private ReflectionKind reflectionKind;
    private ArrayList<String> exportProperties;
    private ArrayList<String> exportSymbols;

    public PackageFooterEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IPackageDefinition definition) {
        IASScope containedScope = definition.getContainedScope();
        ITypeDefinition type = EmitterUtils.findType(containedScope.getAllLocalDefinitions());
        if (type == null) {
            return;
        }
        this.getEmitter().emitSourceMapDirective(type.getNode());
    }

    public void emitClassInfo(ITypeNode tnode) {
        JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)this.getEmitter().getDocEmitter();
        if (!this.getEmitter().getModel().isExterns && doc.getEmitExports().booleanValue()) {
            boolean needsIEventDispatcher;
            boolean isInterface = tnode instanceof IInterfaceNode;
            boolean isDynamic = tnode instanceof IClassNode && tnode.hasModifier(ASModifier.DYNAMIC);
            this.writeNewline();
            this.writeNewline();
            this.writeNewline();
            doc.begin();
            this.writeNewline(" * Metadata");
            this.writeNewline(" *");
            this.writeNewline(" * @type {Object.<string, Array.<Object>>}");
            doc.end();
            this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.writeToken(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write(JSRoyaleEmitterTokens.NAMES);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SQUARE_OPEN);
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write(JSRoyaleEmitterTokens.NAME);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(tnode.getName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(JSRoyaleEmitterTokens.QNAME);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(this.getEmitter().formatQualifiedName(tnode.getQualifiedName()));
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_KIND);
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            if (isInterface) {
                this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_INTERFACE_KIND);
            } else {
                this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_CLASS_KIND);
            }
            if (isDynamic) {
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(JSRoyaleEmitterTokens.ROYALE_CLASS_INFO_IS_DYNAMIC);
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.TRUE);
            } else {
                this.writeToken(ASEmitterTokens.SINGLE_QUOTE);
            }
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SQUARE_CLOSE);
            IExpressionNode[] enodes = tnode instanceof IClassNode ? ((IClassNode)tnode).getImplementedInterfaceNodes() : ((IInterfaceNode)tnode).getExtendedInterfaceNodes();
            boolean bl = needsIEventDispatcher = tnode instanceof IClassNode && ((IClassDefinition)tnode.getDefinition()).needsEventDispatcher(this.getProject()) && this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS;
            if (tnode.getDefinition() instanceof IClassDefinition) {
                this.getModel().unregisterImplicitBindableImplementation((IClassDefinition)tnode.getDefinition());
            }
            if (enodes.length > 0 || needsIEventDispatcher) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write(JSRoyaleEmitterTokens.INTERFACES);
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SQUARE_OPEN);
                if (needsIEventDispatcher) {
                    this.write(this.getEmitter().formatQualifiedName(BindableEmitter.DISPATCHER_INTERFACE_QNAME));
                    if (enodes.length > 0) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                }
                int i = 0;
                for (IExpressionNode enode : enodes) {
                    IDefinition edef = enode.resolve(this.getProject());
                    if (edef == null) continue;
                    this.write(this.getEmitter().formatQualifiedName(edef.getQualifiedName()));
                    if (i < enodes.length - 1) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    ++i;
                }
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
            this.collectReflectionData(tnode);
            IMetaTagNode[] metadata = null;
            IMetaTagsNode metadataTags = tnode.getMetaTags();
            if (metadataTags != null) {
                metadata = metadataTags.getAllTags();
            }
            String typeName = this.getEmitter().formatQualifiedName(tnode.getQualifiedName());
            this.emitReflectionData(typeName, this.reflectionKind, this.varData, this.accessorData, this.methodData, metadata);
            if (!isInterface) {
                this.emitReflectionRegisterInitialStaticFields(typeName, (IClassDefinition)((ClassDefinition)tnode.getDefinition()));
            }
            this.emitExportProperties(typeName, this.exportProperties, this.exportSymbols);
        }
    }

    public void collectReflectionData(ITypeNode tnode) {
        ModifiersSet modifierSet;
        String qualifiedTypeName;
        Object data;
        JSRoyaleEmitter fjs = (JSRoyaleEmitter)this.getEmitter();
        this.exportProperties = new ArrayList();
        this.exportSymbols = new ArrayList();
        ICompilerProject project = this.getWalker().getProject();
        Set<Object> exportMetadata = Collections.emptySet();
        if (project instanceof RoyaleJSProject) {
            RoyaleJSProject fjsp = (RoyaleJSProject)project;
            if (fjsp.config != null) {
                exportMetadata = fjsp.config.getCompilerKeepCodeWithMetadata();
            }
        }
        this.varData = new ArrayList();
        this.accessorData = new ArrayList();
        this.methodData = new ArrayList();
        HashMap<String, JSSessionModel.BindableVarInfo> bindableVars = this.getModel().getBindableVars();
        boolean isInterface = tnode instanceof IInterfaceNode;
        IDefinitionNode[] dnodes = !isInterface ? ((IClassNode)tnode).getAllMemberNodes() : ((IInterfaceNode)tnode).getAllMemberDefinitionNodes();
        this.reflectionKind = isInterface ? ReflectionKind.INTERFACE : ReflectionKind.CLASS;
        for (IDefinitionNode dnode : dnodes) {
            IMetaTagNode[] tags;
            boolean isStatic;
            ModifiersSet modifierSet2 = dnode.getDefinition().getModifiers();
            boolean bl = isStatic = modifierSet2 != null && modifierSet2.hasModifier(ASModifier.STATIC);
            if (dnode.getNodeID() != ASTNodeID.VariableID && dnode.getNodeID() != ASTNodeID.BindableVariableID) continue;
            IVariableNode varNode = (IVariableNode)dnode;
            String ns = varNode.getNamespace();
            boolean isConst = varNode.isConst();
            if (isConst || !isInterface && (ns == null || !ns.equals("public"))) continue;
            String name = varNode.getName();
            IMetaTagsNode metaData = varNode.getMetaTags();
            if (!isInterface && bindableVars.containsKey(name) && bindableVars.get((Object)name).namespace.equals("public")) {
                IMetaTagNode[] tags2;
                AccessorData bindableAccessor = new AccessorData();
                bindableAccessor.name = name;
                bindableAccessor.access = "readwrite";
                bindableAccessor.type = bindableVars.get((Object)name).type;
                bindableAccessor.declaredBy = fjs.formatQualifiedName(tnode.getQualifiedName(), true);
                bindableAccessor.isStatic = isStatic;
                if (metaData != null && (tags2 = metaData.getAllTags()).length > 0) {
                    bindableAccessor.metaData = tags2;
                }
                this.accessorData.add(bindableAccessor);
                continue;
            }
            data = new VariableData();
            this.varData.add((VariableData)data);
            ((VariableData)data).name = name;
            ((VariableData)data).isStatic = isStatic;
            qualifiedTypeName = varNode.getVariableTypeNode().resolveType(this.getProject()).getQualifiedName();
            ((VariableData)data).type = fjs.formatQualifiedName(qualifiedTypeName, true);
            if (metaData == null || (tags = metaData.getAllTags()).length <= 0) continue;
            ((VariableData)data).metaData = tags;
            for (IMetaTagNode tag : tags) {
                String tagName = tag.getTagName();
                if (!exportMetadata.contains(tagName)) continue;
                if (((VariableData)data).isStatic.booleanValue()) {
                    this.exportSymbols.add(((VariableData)data).name);
                    continue;
                }
                this.exportProperties.add(((VariableData)data).name);
            }
        }
        if (this.getModel().hasStaticBindableVars()) {
            AccessorData staticEventDispatcher = new AccessorData();
            staticEventDispatcher.name = BindableEmitter.STATIC_DISPATCHER_GETTER;
            staticEventDispatcher.access = "readonly";
            staticEventDispatcher.type = fjs.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME, true);
            staticEventDispatcher.declaredBy = fjs.formatQualifiedName(tnode.getQualifiedName(), true);
            staticEventDispatcher.isStatic = true;
            this.accessorData.add(staticEventDispatcher);
        }
        HashMap instanceAccessorMap = new HashMap();
        HashMap<String, AccessorData> staticAccessorMap = new HashMap<String, AccessorData>();
        for (IDefinitionNode dnode : dnodes) {
            IMetaTagNode[] tags;
            HashMap<String, AccessorData> accessorMap;
            modifierSet = dnode.getDefinition().getModifiers();
            boolean isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
            HashMap<String, AccessorData> hashMap = accessorMap = isStatic ? staticAccessorMap : instanceAccessorMap;
            if (dnode.getNodeID() != ASTNodeID.GetterID && dnode.getNodeID() != ASTNodeID.SetterID) continue;
            IFunctionNode fnNode = (IFunctionNode)dnode;
            String ns = fnNode.getNamespace();
            if (!isInterface && (ns == null || !ns.equals("public"))) continue;
            String accessorName = fnNode.getName();
            AccessorData data2 = (AccessorData)accessorMap.get(accessorName);
            if (data2 == null) {
                data2 = new AccessorData();
            }
            data2.name = fnNode.getName();
            if (!this.accessorData.contains(data2)) {
                this.accessorData.add(data2);
            }
            if (dnode.getNodeID() == ASTNodeID.GetterID) {
                data2.type = fnNode.getReturnTypeNode().resolveType(this.getProject()).getQualifiedName();
                data2.access = data2.access == null ? "readonly" : "readwrite";
            } else {
                data2.type = ((SetterNode)fnNode).getVariableTypeNode().resolveType(this.getProject()).getQualifiedName();
                data2.access = data2.access == null ? "writeonly" : "readwrite";
            }
            accessorMap.put(data2.name, data2);
            data2.type = fjs.formatQualifiedName(data2.type, true);
            IClassNode declarer = (IClassNode)fnNode.getAncestorOfType(IClassNode.class);
            String declarant = fjs.formatQualifiedName(tnode.getQualifiedName(), true);
            if (declarer != null) {
                declarant = fjs.formatQualifiedName(declarer.getQualifiedName(), true);
            }
            data2.declaredBy = declarant;
            data2.isStatic = isStatic;
            IMetaTagsNode metaData = fnNode.getMetaTags();
            if (metaData == null || (tags = metaData.getAllTags()).length <= 0) continue;
            data2.metaData = tags;
        }
        for (IDefinitionNode dnode : dnodes) {
            IParameterNode[] paramNodes;
            IMetaTagNode[] tags;
            boolean isStatic;
            modifierSet = dnode.getDefinition().getModifiers();
            boolean bl = isStatic = modifierSet != null && modifierSet.hasModifier(ASModifier.STATIC);
            if (dnode.getNodeID() != ASTNodeID.FunctionID) continue;
            IFunctionNode fnNode = (IFunctionNode)dnode;
            String ns = fnNode.getNamespace();
            if (!isInterface && (ns == null || !ns.equals("public"))) continue;
            data = new MethodData();
            ((MethodData)data).isStatic = isStatic;
            this.methodData.add((MethodData)data);
            ((MethodData)data).name = fnNode.getName();
            qualifiedTypeName = fnNode.getReturnType();
            if (!qualifiedTypeName.equals("") && !qualifiedTypeName.equals("void")) {
                qualifiedTypeName = fnNode.getReturnTypeNode().resolveType(this.getProject()).getQualifiedName();
            }
            ((MethodData)data).type = fjs.formatQualifiedName(qualifiedTypeName, true);
            Object declarer = isInterface ? (IInterfaceNode)fnNode.getAncestorOfType(IInterfaceNode.class) : (IClassNode)fnNode.getAncestorOfType(IClassNode.class);
            String declarant = fjs.formatQualifiedName(tnode.getQualifiedName(), true);
            if (declarer != null) {
                declarant = fjs.formatQualifiedName(declarer.getQualifiedName(), true);
            }
            ((MethodData)data).declaredBy = declarant;
            IMetaTagsNode metaData = fnNode.getMetaTags();
            if (metaData != null && (tags = metaData.getAllTags()).length > 0) {
                ((MethodData)data).metaData = tags;
                for (IMetaTagNode tag : tags) {
                    String tagName = tag.getTagName();
                    if (!exportMetadata.contains(tagName)) continue;
                    if (((MethodData)data).isStatic.booleanValue()) {
                        this.exportSymbols.add(((MethodData)data).name);
                        continue;
                    }
                    this.exportProperties.add(((MethodData)data).name);
                }
            }
            if ((paramNodes = fnNode.getParameterNodes()) == null) continue;
            ((MethodData)data).parameters = paramNodes;
        }
    }

    private void emitReflectionDataStart(String typeName) {
        JSRoyaleDocEmitter doc = (JSRoyaleDocEmitter)this.getEmitter().getDocEmitter();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        this.writeNewline();
        doc.begin();
        this.writeNewline(" * Reflection");
        this.writeNewline(" *");
        this.writeNewline(" * @return {Object.<string, Function>}");
        doc.end();
        this.write(typeName);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeToken(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.indentPush();
        this.writeNewline();
    }

    private void emitReflectionDataEnd(String typeName) {
        JSGoogConfiguration config = ((RoyaleJSProject)this.getWalker().getProject()).config;
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.indentPop();
        this.writeNewline();
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.writeNewline(ASEmitterTokens.SEMICOLON);
        if (config == null) {
            return;
        }
        this.writeNewline("/**");
        this.writeNewline(" * @export");
        this.writeNewline(" * @const");
        this.writeNewline(" * @type {number}");
        this.writeNewline(" */");
        this.write(typeName);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSEmitterTokens.PROTOTYPE);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.write(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        this.writeToken(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO_COMPILE_TIME_FLAGS);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.write(String.valueOf(config.getReflectionFlags()));
        this.writeNewline(ASEmitterTokens.SEMICOLON);
    }

    public void emitReflectionData(String typeName, ReflectionKind outputType, List<VariableData> varData, List<AccessorData> accessorData, List<MethodData> methodData, IMetaTagNode[] metaData) {
        int count;
        this.emitReflectionDataStart(typeName);
        if (outputType == ReflectionKind.CLASS) {
            this.write("variables");
            this.writeToken(ASEmitterTokens.COLON);
            this.writeToken(ASEmitterTokens.FUNCTION);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.writeToken(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            if (varData.size() == 0) {
                this.writeEmptyContent(true, true);
            } else {
                this.indentPush();
                this.writeNewline();
                this.writeToken(ASEmitterTokens.RETURN);
                this.write(ASEmitterTokens.BLOCK_OPEN);
                this.indentPush();
                count = 0;
                for (VariableData var : varData) {
                    if (count > 0) {
                        this.write(ASEmitterTokens.COMMA);
                    }
                    this.writeNewline();
                    ++count;
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    if (var.isStatic.booleanValue()) {
                        this.write("|");
                    }
                    this.write(var.name);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.writeToken(ASEmitterTokens.COLON);
                    this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                    this.write("type");
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(var.type);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO_GET_SET);
                    this.writeToken(ASEmitterTokens.COLON);
                    this.writeToken(ASEmitterTokens.FUNCTION);
                    boolean valueIsUntyped = var.type.equals("*");
                    if (valueIsUntyped) {
                        this.write("f");
                    }
                    this.write(ASEmitterTokens.PAREN_OPEN);
                    if (!var.isStatic.booleanValue()) {
                        this.writeToken("/** " + typeName + " */");
                        this.write("inst");
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    this.write("/** * */ v");
                    this.writeToken(ASEmitterTokens.PAREN_CLOSE);
                    this.write(ASEmitterTokens.BLOCK_OPEN);
                    String field = var.isStatic != false ? typeName + "." + var.name : "inst." + var.name;
                    String getterSetter = valueIsUntyped ? "return v !== f ? " + field + " = v : " + field + ";" : "return v !== undefined ? " + field + " = v : " + field + ";";
                    this.write(getterSetter);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                    IMetaTagNode[] tags = var.metaData;
                    if (tags != null) {
                        this.writeMetaData(tags, true, false);
                    }
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                }
                this.indentPop();
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.SEMICOLON);
                this.indentPop();
                this.writeNewline();
                this.write(ASEmitterTokens.BLOCK_CLOSE);
                this.write(ASEmitterTokens.COMMA);
                this.writeNewline();
            }
        }
        this.write("accessors");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        if (accessorData.size() == 0) {
            this.writeEmptyContent(true, true);
        } else {
            this.indentPush();
            this.writeNewline();
            this.writeToken(ASEmitterTokens.RETURN);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.indentPush();
            count = 0;
            for (AccessorData accessor : accessorData) {
                if (count > 0) {
                    this.write(ASEmitterTokens.COMMA);
                }
                this.writeNewline();
                ++count;
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                if (accessor.isStatic.booleanValue()) {
                    this.write("|");
                }
                this.write(accessor.name);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COLON);
                this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                this.write("type");
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(accessor.type);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("access");
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(accessor.access);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("declaredBy");
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(accessor.declaredBy);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                IMetaTagNode[] tags = accessor.metaData;
                if (tags != null) {
                    this.writeMetaData(tags, true, false);
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.indentPop();
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
            this.indentPop();
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.COMMA);
            this.writeNewline();
        }
        this.write("methods");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        if (methodData.size() == 0) {
            this.writeEmptyContent(false, false);
        } else {
            this.indentPush();
            this.writeNewline();
            this.writeToken(ASEmitterTokens.RETURN);
            this.write(ASEmitterTokens.BLOCK_OPEN);
            this.indentPush();
            count = 0;
            for (MethodData method : methodData) {
                IMetaTagNode[] metas;
                if (count > 0) {
                    this.write(ASEmitterTokens.COMMA);
                }
                this.writeNewline();
                ++count;
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                if (method.isStatic.booleanValue()) {
                    this.write("|");
                }
                this.write(method.name);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COLON);
                this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                this.write("type");
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(method.type);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("declaredBy");
                this.writeToken(ASEmitterTokens.COLON);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(method.declaredBy);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                IParameterNode[] params = method.parameters;
                if (params != null && params.length > 0) {
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.writeParameters(params);
                }
                if ((metas = method.metaData) != null) {
                    this.writeMetaData(metas, true, false);
                }
                this.write(ASEmitterTokens.BLOCK_CLOSE);
            }
            this.indentPop();
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
            this.indentPop();
            this.writeNewline();
            this.write(ASEmitterTokens.BLOCK_CLOSE);
        }
        if (metaData != null && metaData.length > 0) {
            this.writeMetaData(metaData, true, true);
        }
        this.indentPop();
        this.emitReflectionDataEnd(typeName);
    }

    private void writeEmptyContent(Boolean appendComma, Boolean includeNewline) {
        this.writeToken(ASEmitterTokens.RETURN);
        this.write(ASEmitterTokens.BLOCK_OPEN);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        this.write(ASEmitterTokens.SEMICOLON);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
        if (appendComma.booleanValue()) {
            this.write(ASEmitterTokens.COMMA);
        }
        if (includeNewline.booleanValue()) {
            this.writeNewline();
        }
    }

    private void writeParameters(IParameterNode[] params) {
        this.write("parameters");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.writeToken(ASEmitterTokens.BLOCK_OPEN);
        this.writeToken(ASEmitterTokens.RETURN);
        this.writeToken(ASEmitterTokens.SQUARE_OPEN);
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            IParameterDefinition parameterDefinition = (IParameterDefinition)params[i].getDefinition();
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("index");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(Integer.toString(i + 1));
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("type");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            ITypeDefinition pd = parameterDefinition.resolveType(this.getProject());
            if (pd == null) {
                UnknownTypeProblem problem = new UnknownTypeProblem((IASNode)parameterDefinition.getNode(), parameterDefinition.getQualifiedName());
                this.getProject().getProblems().add(problem);
                this.write("not found");
            } else {
                this.write(pd.getQualifiedName());
            }
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write("optional");
            this.writeToken(ASEmitterTokens.COLON);
            this.writeToken(parameterDefinition.hasDefaultValue() ? ASEmitterTokens.TRUE : ASEmitterTokens.FALSE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            if (i >= len - 1) continue;
            this.write(ASEmitterTokens.COMMA);
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.writeToken(ASEmitterTokens.SEMICOLON);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    private ArrayList<IMetaTagNode> getAllowedMetadata(IMetaTagNode[] tags) {
        JSGoogConfiguration config = ((RoyaleJSProject)this.getWalker().getProject()).config;
        Set allowedNames = config.getCompilerKeepAs3Metadata();
        ArrayList<IMetaTagNode> filteredTags = new ArrayList<IMetaTagNode>(tags.length);
        for (IMetaTagNode tag : tags) {
            if (!allowedNames.contains(tag.getTagName())) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    private void writeAllowedMetadata(ArrayList<IMetaTagNode> filteredTags) {
        int count = 0;
        int len = filteredTags.size();
        this.write("metadata");
        this.writeToken(ASEmitterTokens.COLON);
        this.writeToken(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.writeToken(ASEmitterTokens.PAREN_CLOSE);
        this.writeToken(ASEmitterTokens.BLOCK_OPEN);
        this.writeToken(ASEmitterTokens.RETURN);
        this.writeToken(ASEmitterTokens.SQUARE_OPEN);
        for (IMetaTagNode tag : filteredTags) {
            ++count;
            this.writeToken(ASEmitterTokens.BLOCK_OPEN);
            this.write("name");
            this.writeToken(ASEmitterTokens.COLON);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(tag.getTagName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            IMetaTagAttribute[] args = tag.getAllAttributes();
            if (args.length > 0) {
                this.writeToken(ASEmitterTokens.COMMA);
                this.write("args");
                this.writeToken(ASEmitterTokens.COLON);
                this.writeToken(ASEmitterTokens.SQUARE_OPEN);
                for (int j = 0; j < args.length; ++j) {
                    if (j > 0) {
                        this.writeToken(ASEmitterTokens.COMMA);
                    }
                    IMetaTagAttribute arg = args[j];
                    this.writeToken(ASEmitterTokens.BLOCK_OPEN);
                    this.write("key");
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    String key = arg.getKey();
                    this.write(key == null ? "" : key);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.writeToken(ASEmitterTokens.COMMA);
                    this.write("value");
                    this.writeToken(ASEmitterTokens.COLON);
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(this.formatJSStringValue(arg.getValue()));
                    this.write(ASEmitterTokens.SINGLE_QUOTE);
                    this.write(ASEmitterTokens.SPACE);
                    this.write(ASEmitterTokens.BLOCK_CLOSE);
                }
                this.write(ASEmitterTokens.SPACE);
                this.write(ASEmitterTokens.SQUARE_CLOSE);
            }
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.BLOCK_CLOSE);
            if (count <= 0 || count >= len) continue;
            this.writeToken(ASEmitterTokens.COMMA);
        }
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.SQUARE_CLOSE);
        this.writeToken(ASEmitterTokens.SEMICOLON);
        this.write(ASEmitterTokens.BLOCK_CLOSE);
    }

    private void writeMetaData(IMetaTagNode[] tags, boolean prefixComma, boolean prefixNewline) {
        ArrayList<IMetaTagNode> filteredTags = this.getAllowedMetadata(tags);
        if (filteredTags.size() == 0) {
            return;
        }
        if (prefixNewline) {
            if (prefixComma) {
                this.write(ASEmitterTokens.COMMA);
            }
            this.writeNewline();
        } else if (prefixComma) {
            this.writeToken(ASEmitterTokens.COMMA);
        }
        this.writeAllowedMetadata(filteredTags);
    }

    private String formatJSStringValue(String value) {
        value = value.replace("'", "\\'");
        return value;
    }

    public void emitReflectionRegisterInitialStaticFields(String typeName, IClassDefinition classDef) {
        JSGoogConfiguration config = ((RoyaleJSProject)this.getWalker().getProject()).config;
        if (config == null || !config.getJsDefaultInitializers()) {
            return;
        }
        boolean needsStaticsList = false;
        Collection defs = classDef.getContainedScope().getAllLocalDefinitionSets();
        for (IDefinitionSet set : defs) {
            int l = set.getSize();
            for (int i = 0; i < l; ++i) {
                IDefinition d = set.getDefinition(i);
                if (!d.isStatic()) continue;
                needsStaticsList = true;
                break;
            }
            if (!needsStaticsList) continue;
            break;
        }
        if (needsStaticsList) {
            this.writeNewline("/**");
            this.writeNewline(" * Provide reflection support for distinguishing dynamic fields on class object (static)");
            this.writeNewline(" * @export");
            this.writeNewline(" * @const");
            this.writeNewline(" * @type {Array<string>}");
            this.writeNewline(" */");
            this.write(typeName);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.writeToken(JSRoyaleEmitterTokens.ROYALE_REFLECTION_INFO_INITIAL_STATICS);
            this.writeToken(ASEmitterTokens.EQUAL);
            this.write("Object.keys");
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(typeName);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        }
    }

    public void emitExportProperties(String typeName, ArrayList<String> exportProperties, ArrayList<String> exportSymbols) {
        for (String prop : exportSymbols) {
            this.write(JSRoyaleEmitterTokens.GOOG_EXPORT_SYMBOL);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(typeName);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(prop);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(typeName);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(prop);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
        for (String prop : exportProperties) {
            this.write(JSRoyaleEmitterTokens.GOOG_EXPORT_PROPERTY);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(typeName);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(prop);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.SPACE);
            this.write(typeName);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(JSEmitterTokens.PROTOTYPE);
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.write(prop);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.writeNewline(ASEmitterTokens.SEMICOLON);
        }
    }

    public class AccessorData
    extends MethodData {
        public String access;
    }

    public class MethodData {
        public String name;
        public String type;
        public Boolean isStatic = false;
        public String declaredBy;
        public IParameterNode[] parameters;
        public IMetaTagNode[] metaData;
    }

    public class VariableData {
        public String name;
        public String type;
        public Boolean isStatic = false;
        public IMetaTagNode[] metaData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReflectionKind {
        CLASS,
        INTERFACE;

    }
}

