/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IFunctionDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCallArgumentsEmitter
extends JSSubEmitter
implements ISubEmitter<IContainerNode> {
    public FunctionCallArgumentsEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    @Override
    public void emit(IContainerNode node) {
        IDefinition calledDef;
        this.startMapping((ISourceLocation)node);
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        IParameterDefinition[] paramDefs = null;
        IFunctionCallNode functionCallNode = (IFunctionCallNode)node.getAncestorOfType(IFunctionCallNode.class);
        if (functionCallNode != null && (calledDef = functionCallNode.resolveCalledExpression(this.getProject())) instanceof IFunctionDefinition) {
            IFunctionDefinition functionDef = (IFunctionDefinition)calledDef;
            paramDefs = functionDef.getParameters();
        }
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            IExpressionNode argumentNode = (IExpressionNode)node.getChild(i);
            ITypeDefinition paramTypeDef = null;
            if (paramDefs != null && paramDefs.length > i) {
                IParameterDefinition paramDef = paramDefs[i];
                if (paramDef.isRest()) {
                    paramDef = null;
                }
                if (paramDef != null) {
                    paramTypeDef = paramDef.resolveType(this.getProject());
                }
            }
            this.getEmitter().emitAssignmentCoercion(argumentNode, (IDefinition)paramTypeDef);
            if (i >= len - 1) continue;
            this.startMapping((ISourceLocation)node, (ISourceLocation)argumentNode);
            this.writeToken(ASEmitterTokens.COMMA);
            this.endMapping((ISourceLocation)node);
        }
        this.startMapping((ISourceLocation)node, node.getLine(), node.getColumn() + node.getAbsoluteEnd() - node.getAbsoluteStart() - 1);
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.endMapping((ISourceLocation)node);
    }
}

