/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.clients;

import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.royale.compiler.asdoc.IASDocDelegate;
import org.apache.royale.compiler.clients.MXMLJSC;
import org.apache.royale.compiler.clients.MXMLJSCRoyale;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.codegen.as.IASWriter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleASDocEmitter;
import org.apache.royale.compiler.driver.IBackend;
import org.apache.royale.compiler.driver.js.IJSApplication;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.driver.as.ASBackend;
import org.apache.royale.compiler.internal.driver.js.amd.AMDBackend;
import org.apache.royale.compiler.internal.driver.js.goog.ASDocConfiguration;
import org.apache.royale.compiler.internal.driver.js.goog.GoogBackend;
import org.apache.royale.compiler.internal.driver.mxml.jsc.MXMLJSCJSSWCBackend;
import org.apache.royale.compiler.internal.driver.mxml.royale.MXMLRoyaleASDocBackend;
import org.apache.royale.compiler.internal.driver.mxml.royale.MXMLRoyaleASDocDITABackend;
import org.apache.royale.compiler.internal.driver.mxml.royale.MXMLRoyaleBackend;
import org.apache.royale.compiler.internal.parsing.as.RoyaleASDocDelegate;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleASDocProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.targets.JSTarget;
import org.apache.royale.compiler.internal.targets.RoyaleSWCTarget;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.InternalCompilerProblem;
import org.apache.royale.compiler.problems.UnableToBuildSWFProblem;
import org.apache.royale.compiler.targets.ITarget;
import org.apache.royale.compiler.targets.ITargetSettings;
import org.apache.royale.compiler.units.ICompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASDOCJSC
extends MXMLJSCRoyale {
    String middle = "";

    @Override
    public String getName() {
        return "ASDOC";
    }

    @Override
    public int execute(String[] args) {
        return ASDOCJSC.staticMainNoExit(args);
    }

    public static void main(String[] args) {
        int exitCode = ASDOCJSC.staticMainNoExit(args);
        System.exit(exitCode);
    }

    public static int staticMainNoExit(String[] args) {
        long startTime = System.nanoTime();
        IBackend backend = new ASBackend();
        block7: for (String s : args) {
            if (!s.contains("js-output-type")) continue;
            jsOutputType = MXMLJSC.JSOutputType.fromString(s.split("=")[1]);
            switch (jsOutputType) {
                case AMD: {
                    backend = new AMDBackend();
                    continue block7;
                }
                case JSC: {
                    backend = new MXMLJSCJSSWCBackend();
                    continue block7;
                }
                case ROYALE: 
                case ROYALE_DUAL: {
                    backend = new MXMLRoyaleASDocBackend();
                    continue block7;
                }
                case ROYALE_DITA: {
                    backend = new MXMLRoyaleASDocDITABackend();
                    continue block7;
                }
                case GOOG: {
                    backend = new GoogBackend();
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        ASDOCJSC mxmlc = new ASDOCJSC(backend);
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        int exitCode = mxmlc.mainNoExit(args, problems, true);
        long endTime = System.nanoTime();
        System.out.println((double)(endTime - startTime) / 1.0E9 + " seconds");
        return exitCode;
    }

    public ASDOCJSC(IBackend backend) {
        super(backend);
        this.project = new RoyaleASDocProject(this.workspace, backend);
    }

    protected void init() {
        MXMLRoyaleBackend backend = new MXMLRoyaleBackend();
        this.workspace = new Workspace();
        this.workspace.setASDocDelegate((IASDocDelegate)new RoyaleASDocDelegate());
        this.project = new RoyaleJSProject(this.workspace, backend);
        this.problems = new ProblemQuery();
        this.asFileHandler = backend.getSourceFileHandlerInstance();
    }

    @Override
    protected boolean compile() {
        boolean compilationSuccess = false;
        try {
            this.project.getSourceCompilationUnitFactory().addHandler(this.asFileHandler);
            if (this.setupTargetFile()) {
                this.buildArtifact();
            }
            if (this.jsTarget != null) {
                Map defs;
                String swf;
                ArrayList errors = new ArrayList();
                ArrayList warnings = new ArrayList();
                if (!this.config.getCreateTargetWithErrors()) {
                    this.problems.getErrorsAndWarnings(errors, warnings);
                    if (errors.size() > 0) {
                        return false;
                    }
                }
                if ((swf = (String)(defs = this.config.getCompilerDefine()).get("COMPILE::SWF")) != null) {
                    this.middle = swf.equals("true") ? ".swf" : ".js";
                }
                String outputFolderName = this.getOutputFilePath();
                File outputFolder = null;
                outputFolder = new File(outputFolderName);
                Set externs = this.config.getExterns();
                List<String> excludeClasses = ((ASDocConfiguration)this.config).getExcludeClasses();
                List<String> excludeSources = ((ASDocConfiguration)this.config).getExcludeSources();
                ImmutableList roots = ((RoyaleSWCTarget)this.target).getReachableCompilationUnits(errors);
                List reachableCompilationUnits = this.project.getReachableCompilationUnitsInSWFOrder(roots);
                for (ICompilationUnit cu : reachableCompilationUnits) {
                    String symbol;
                    ICompilationUnit.UnitType cuType = cu.getCompilationUnitType();
                    if (cuType != ICompilationUnit.UnitType.AS_UNIT && cuType != ICompilationUnit.UnitType.MXML_UNIT || externs.contains(symbol = (String)cu.getQualifiedNames().get(0)) || excludeClasses.contains(symbol)) continue;
                    String sourceFile = cu.getAbsoluteFilename();
                    if (excludeSources.contains(sourceFile = sourceFile.replace("\\", "/"))) continue;
                    File outputClassFile = this.getOutputClassFile((String)cu.getQualifiedNames().get(0), outputFolder);
                    if (this.config.isVerbose()) {
                        System.out.println("Compiling file: " + outputClassFile);
                    }
                    ICompilationUnit unit = cu;
                    IASWriter writer = cuType == ICompilationUnit.UnitType.AS_UNIT ? this.project.getBackend().createWriter(this.project, errors, unit, false) : this.project.getBackend().createMXMLWriter(this.project, errors, unit, false);
                    this.problems.addAll(errors);
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputClassFile));
                    writer.writeTo(out);
                    out.flush();
                    out.close();
                    writer.close();
                }
                compilationSuccess = true;
                IJSRoyaleASDocEmitter emitter = (IJSRoyaleASDocEmitter)((Object)this.project.getBackend().createEmitter(null));
                emitter.outputIndex(outputFolder, (RoyaleASDocProject)this.project);
                emitter.outputClasses(outputFolder, (RoyaleASDocProject)this.project);
                emitter.outputTags(outputFolder, (RoyaleASDocProject)this.project);
            }
        }
        catch (Exception e) {
            InternalCompilerProblem problem = new InternalCompilerProblem(e);
            this.problems.add((ICompilerProblem)problem);
        }
        return compilationSuccess;
    }

    @Override
    protected void buildArtifact() throws InterruptedException, IOException, ConfigurationException {
        this.jsTarget = this.buildJSTarget();
    }

    private IJSApplication buildJSTarget() throws InterruptedException, FileNotFoundException, ConfigurationException {
        ArrayList<ICompilerProblem> problemsBuildingSWF = new ArrayList<ICompilerProblem>();
        IJSApplication app = this.buildApplication((CompilerProject)this.project, this.config.getMainDefinition(), null, problemsBuildingSWF);
        this.problems.addAll(problemsBuildingSWF);
        if (app == null) {
            UnableToBuildSWFProblem problem = new UnableToBuildSWFProblem(this.getOutputFilePath());
            this.problems.add((ICompilerProblem)problem);
        }
        return app;
    }

    private IJSApplication buildApplication(CompilerProject applicationProject, String rootClassName, ICompilationUnit mainCU, Collection<ICompilerProblem> problems) throws InterruptedException, ConfigurationException, FileNotFoundException {
        Collection fatalProblems = applicationProject.getFatalProblems();
        if (!fatalProblems.isEmpty()) {
            problems.addAll(fatalProblems);
            return null;
        }
        return ((JSTarget)this.target).build(mainCU, problems);
    }

    private String getOutputFilePath() {
        if (this.config.getOutput() == null) {
            String extension = "." + this.project.getBackend().getOutputExtension();
            return FilenameUtils.removeExtension(this.config.getTargetFile()).concat(extension);
        }
        String outputFolderName = this.config.getOutput();
        return outputFolderName;
    }

    private File getOutputClassFile(String qname, File outputFolder) {
        String[] cname = qname.split("\\.");
        String sdirPath = outputFolder + File.separator;
        if (cname.length > 0) {
            int n = cname.length - 1;
            for (int i = 0; i < n; ++i) {
                sdirPath = sdirPath + cname[i] + File.separator;
            }
            File sdir = new File(sdirPath);
            if (!sdir.exists()) {
                sdir.mkdirs();
            }
            qname = cname[cname.length - 1];
        }
        return new File(sdirPath + qname + this.middle + "." + this.project.getBackend().getOutputExtension());
    }

    @Override
    protected boolean setupTargetFile() throws InterruptedException {
        this.config.getTargetFile();
        ITargetSettings settings = this.getTargetSettings();
        if (settings == null) {
            return false;
        }
        this.project.setTargetSettings(settings);
        this.target = this.project.getBackend().createTarget(this.project, this.getTargetSettings(), null);
        return true;
    }

    private ITargetSettings getTargetSettings() {
        if (this.targetSettings == null) {
            this.targetSettings = this.projectConfigurator.getTargetSettings(this.getTargetType());
        }
        if (this.targetSettings == null) {
            this.problems.addAll((Iterable)this.projectConfigurator.getConfigurationProblems());
        }
        return this.targetSettings;
    }

    @Override
    protected void validateTargetFile() throws ConfigurationException {
    }

    protected String getProgramName() {
        return "compc";
    }

    protected boolean isCompc() {
        return true;
    }

    @Override
    protected ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_PROBLEMS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }
    }
}

