/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastStack<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 7491447816791648090L;
    private IFastStackDecorator<E> decorator;

    public FastStack() {
        super(3);
    }

    public FastStack(int size) {
        super(size);
    }

    public FastStack(Collection<? extends E> c) {
        super(c);
    }

    public void setStackDecorator(IFastStackDecorator<E> decorator) {
        this.decorator = decorator;
    }

    public void push(E entry) {
        this.add(entry);
    }

    public E pop() {
        Object retVal = null;
        int size = this.size();
        if (size > 0) {
            retVal = this.remove(size - 1);
        }
        if (this.decorator != null) {
            return this.decorator.decorate(retVal);
        }
        return retVal;
    }

    public E peek() {
        Object retVal = null;
        int size = this.size();
        if (size > 0) {
            retVal = this.get(size - 1);
        }
        if (this.decorator != null) {
            return this.decorator.decorate(retVal);
        }
        return retVal;
    }

    @Override
    public Object clone() {
        FastStack<E> st = new FastStack<E>((ArrayList)super.clone());
        return st;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IFastStackDecorator<E> {
        public E decorate(E var1);
    }
}

