/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.XMLBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.problems.MXMLXMLListMixedContentProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLXMLListNode;

class MXMLXMLListNode
extends MXMLInstanceNode
implements IMXMLXMLListNode {
    private ArrayList<IMXMLTagData> childTags = new ArrayList();
    private String xmlString;

    MXMLXMLListNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLXMLListID;
    }

    public String getName() {
        return "XMLList";
    }

    public String getXMLString() {
        return this.xmlString;
    }

    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        this.childTags.add(childTag);
    }

    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        builder.addProblem(new MXMLXMLListMixedContentProblem(tag));
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.analyzeXML(builder);
        super.initializationComplete(builder, tag, info);
        this.childTags = null;
    }

    private void analyzeXML(MXMLTreeBuilder builder) {
        StringWriter sw = new StringWriter();
        for (IMXMLTagData tag : this.childTags) {
            new XMLBuilder(this, tag, tag.getCompositePrefixMap(), builder).processNode(tag, sw);
        }
        this.xmlString = sw.toString();
    }
}

