/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLLiteralNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLUintNode;

class MXMLUintNode
extends MXMLExpressionNodeBase
implements IMXMLUintNode {
    private static final Integer DEFAULT = 0;

    MXMLUintNode(NodeBase parent) {
        super(parent);
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLUintID;
    }

    public String getName() {
        return "uint";
    }

    public long getValue() {
        assert (this.getExpressionNode() instanceof MXMLLiteralNode) : "getValue() shouldn't be getting called on a non-literal MXMLUintNode";
        MXMLLiteralNode literalNode = (MXMLLiteralNode)this.getExpressionNode();
        Object value = literalNode.getValue();
        if (value instanceof Integer) {
            return ((Integer)literalNode.getValue()).intValue();
        }
        return (Long)literalNode.getValue();
    }

    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.UINT;
    }

    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.createExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        super.initializationComplete(builder, tag, info);
    }
}

