/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.Collection;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragmentsReader;
import org.apache.royale.compiler.internal.parsing.as.ASParser;
import org.apache.royale.compiler.internal.parsing.as.OffsetLookup;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.mxml.IMXMLBindingAttributeNode;

class MXMLBindingAttributeNode
extends MXMLNodeBase
implements IMXMLBindingAttributeNode {
    private String attributeName;
    private IExpressionNode expressionNode;

    MXMLBindingAttributeNode(NodeBase parent) {
        super(parent);
    }

    MXMLBindingAttributeNode(NodeBase parent, IExpressionNode expr) {
        super(parent);
        this.expressionNode = expr;
    }

    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLBindingAttributeID;
    }

    public String getName() {
        return this.attributeName;
    }

    public void setName(String s) {
        this.attributeName = s;
    }

    public int getChildCount() {
        return this.expressionNode != null ? 1 : 0;
    }

    public IASNode getChild(int i) {
        return i == 0 ? this.expressionNode : null;
    }

    public IExpressionNode getExpressionNode() {
        return this.expressionNode;
    }

    public void initializeFromAttribute(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        this.attributeName = attribute.getName();
        this.setLocation(attribute);
        this.expressionNode = this.createExpressionNode(builder, attribute);
        if (this.expressionNode != null) {
            ((ExpressionNodeBase)this.expressionNode).setParent(this);
        }
    }

    private IExpressionNode createExpressionNode(MXMLTreeBuilder builder, IMXMLTagAttributeData attribute) {
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        MXMLFileScope fileScope = builder.getFileScope();
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
        for (ISourceFragment fragment : fragments) {
            int physicalStart = fragment.getPhysicalStart();
            int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(attribute.getSourcePath(), physicalStart);
            ((SourceFragment)fragment).setPhysicalStart(absoluteOffsets[0]);
        }
        SourceFragmentsReader reader = new SourceFragmentsReader(attribute.getSourcePath(), fragments);
        return ASParser.parseDataBinding(workspace, reader, problems);
    }

    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }
}

