/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragmentsReader;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLBooleanNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLIntNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLLiteralNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNumberNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLScriptNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLStringNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.internal.tree.mxml.MXMLUintNode;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLTextData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.compiler.problems.MXMLIncompatibleArrayElementProblem;
import org.apache.royale.compiler.problems.MXMLUnexpectedTagProblem;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLArrayNode;
import org.apache.royale.compiler.tree.mxml.IMXMLNode;
import org.apache.royale.compiler.tree.mxml.IMXMLPropertySpecifierNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MXMLArrayNode
extends MXMLInstanceNode
implements IMXMLArrayNode {
    protected static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE);
    private String propertyName;
    private String arrayElementType;

    MXMLArrayNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLArrayID;
    }

    @Override
    public String getName() {
        return "Array";
    }

    @Override
    protected final void initializeFromTag(MXMLTreeBuilder builder, IMXMLTagData tag) {
        IMXMLNode parent = (IMXMLNode)this.getParent();
        if (parent instanceof IMXMLPropertySpecifierNode) {
            this.propertyName = ((IMXMLPropertySpecifierNode)parent).getName();
            IVariableDefinition propertyDefinition = (IVariableDefinition)((IMXMLPropertySpecifierNode)parent).getDefinition();
            RoyaleProject project = builder.getProject();
            this.arrayElementType = propertyDefinition != null ? propertyDefinition.getArrayElementType(project) : "Object";
        }
        super.initializeFromTag(builder, tag);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        this.processFragments(builder, info);
        if (builder.getFileScope().isScriptTag(childTag)) {
            builder.addProblem(new MXMLUnexpectedTagProblem(childTag));
            return;
        }
        RoyaleProject project = builder.getProject();
        String tagName = builder.getFileScope().resolveTagToQualifiedName(childTag);
        IDefinition definition = project.getScope().findDefinitionByName(tagName);
        if (definition instanceof ClassDefinition) {
            MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, tagName, this);
            instanceNode.setClassReference(project, (ClassDefinition)definition);
            instanceNode.initializeFromTag(builder, childTag);
            info.addChildNode(instanceNode);
            if (this.arrayElementType != null && !((ClassDefinition)definition).isInstanceOf(this.arrayElementType, (ICompilerProject)project)) {
                MXMLIncompatibleArrayElementProblem problem = new MXMLIncompatibleArrayElementProblem(childTag, this.propertyName, this.arrayElementType, definition.getQualifiedName());
                builder.addProblem(problem);
            }
        } else {
            String uri = childTag.getURI();
            if (uri != null && uri.equals("http://ns.adobe.com/mxml/2009")) {
                MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, childTag.getShortName(), this);
                instanceNode.setClassReference(project, childTag.getShortName());
                instanceNode.initializeFromTag(builder, childTag);
                info.addChildNode(instanceNode);
            } else {
                builder.addProblem(new MXMLUnresolvedTagProblem(childTag));
                return;
            }
        }
    }

    @Override
    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.processFragments(builder, info);
        this.setChildren(info.getChildNodeList().toArray(new MXMLInstanceNode[0]));
    }

    private void processFragments(MXMLTreeBuilder builder, MXMLNodeBase.MXMLNodeInfo info) {
        ISourceFragment[] fragments = info.getSourceFragments();
        String text = SourceFragmentsReader.concatLogicalText(fragments);
        if (!builder.getMXMLDialect().isWhitespace(text)) {
            ITypeDefinition type = builder.getBuiltinType("*");
            SourceLocation location = info.getSourceLocation();
            MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
            MXMLInstanceNode instanceNode = builder.createInstanceNode(this, type, fragments, location, FLAGS, classNode);
            info.addChildNode(instanceNode);
        }
        info.clearFragments();
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<IMXMLUnitData> contentUnits) {
        RoyaleProject project = builder.getProject();
        this.setLocation(builder, contentUnits);
        this.setClassReference(project, "Array");
        ArrayList<MXMLNodeBase> children = new ArrayList<MXMLNodeBase>();
        for (IMXMLUnitData unit : contentUnits) {
            if (!(unit instanceof IMXMLTagData)) continue;
            IMXMLTagData tag = (IMXMLTagData)unit;
            if (builder.getFileScope().isScriptTag(tag)) {
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, tag);
                children.add(scriptNode);
                continue;
            }
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (definition instanceof IClassDefinition) {
                MXMLInstanceNode childNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                childNode.setClassReference(project, (ClassDefinition)definition);
                childNode.initializeFromTag(builder, tag);
                children.add(childNode);
                continue;
            }
            builder.getProblems().add(new MXMLUnresolvedTagProblem(tag));
        }
        this.setChildren(children.toArray(new IMXMLNode[0]));
    }

    public void initialize(MXMLTreeBuilder builder, ISourceLocation location, List<?> value) {
        this.setLocation(location);
        this.setClassReference(builder.getProject(), "Array");
        ArrayList<MXMLExpressionNodeBase> childList = new ArrayList<MXMLExpressionNodeBase>();
        for (Object element : value) {
            MXMLLiteralNode literalNode;
            if (element instanceof Boolean) {
                MXMLBooleanNode booleanNode = new MXMLBooleanNode(this);
                literalNode = new MXMLLiteralNode(booleanNode, element);
                literalNode.setLocation(location);
                booleanNode.initialize(builder, location, "Boolean", literalNode);
                childList.add(booleanNode);
                continue;
            }
            if (element instanceof Integer) {
                MXMLIntNode intNode = new MXMLIntNode(this);
                literalNode = new MXMLLiteralNode(intNode, element);
                literalNode.setLocation(location);
                intNode.initialize(builder, location, "int", literalNode);
                childList.add(intNode);
                continue;
            }
            if (element instanceof Long) {
                MXMLUintNode uintNode = new MXMLUintNode(this);
                literalNode = new MXMLLiteralNode(uintNode, element);
                literalNode.setLocation(location);
                uintNode.initialize(builder, location, "uint", literalNode);
                childList.add(uintNode);
                continue;
            }
            if (element instanceof Number) {
                MXMLNumberNode numberNode = new MXMLNumberNode(this);
                literalNode = new MXMLLiteralNode(numberNode, element);
                literalNode.setLocation(location);
                numberNode.initialize(builder, location, "Number", literalNode);
                childList.add(numberNode);
                continue;
            }
            if (!(element instanceof String)) continue;
            MXMLStringNode stringNode = new MXMLStringNode(this);
            literalNode = new MXMLLiteralNode(stringNode, element);
            literalNode.setLocation(location);
            stringNode.initialize(builder, location, "String", literalNode);
            childList.add(stringNode);
        }
        this.setChildren(childList.toArray(new IMXMLNode[0]));
    }
}

